package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.BrandEntity;
import com.ejianc.foundation.share.service.IBrandService;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/brandApi/")
public class BrandApi {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IBrandService service;
    @GetMapping("queryBrandByName")
    public CommonResponse<BrandVO> queryBrandByName(@RequestParam(value = "name") String name) {
        QueryWrapper<BrandEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("brand_name",name);
        queryWrapper.eq("state",1);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<BrandEntity> list = service.list(queryWrapper);
        BrandVO vo = null;
        if (ListUtil.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), BrandVO.class);
        }
        if (vo == null) {
            return CommonResponse.error("查询失败,没有查询到该品牌信息！");
        }
        return CommonResponse.success("查询成功！", vo);
    }



}
