package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.util.PSRMMethodConsts;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/supplierApi/")
public class SupplierApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private ISupplierLinkerService linkerService;

    @Autowired
    private IBillTypeService billTypeService;

    @Autowired
    private PSRMRestUtil psrmRestUtil;

    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("queryById")
    CommonResponse<SupplierVO> queryById(@RequestParam(value = "id") Long id) {
        SupplierVO vo = supplierService.queryDetail(id);

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据供应商Ids查询供应商信息
     *
     * @param ids 供应商Id
     * @return
     */
    @GetMapping("querySupplierByIds")
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids) {
        List<SupplierVO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            vos = BeanMapper.mapList(entitys, SupplierVO.class);
        }
        return CommonResponse.success("查询成功！", vos);
    }

    /**
     * 根据供应商来源Id查询供应商信息
     *
     * @param sourceId 供应商Id
     * @return
     */
    @GetMapping("queryBySourceId")
    CommonResponse<SupplierVO> queryBySourceId(@RequestParam(value = "sourceId") String sourceId){
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("source_id", sourceId);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            return CommonResponse.success("查询成功！", BeanMapper.map(entitys.get(0), SupplierVO.class));
        }
        return CommonResponse.error("根据来源ID查询供应商失败！");
    }

    /**
     * 新增或者修改
     *
     * @param vo
     * @return
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO vo) {
        SupplierEntity save = BeanMapper.map(vo, SupplierEntity.class);
        //1、校验数据是否已存在，存在则执行修改方法，否则执行新增方法
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("source_id", vo.getSourceId());
        SupplierEntity entity = supplierService.getOne(queryWrapper);
        if(entity != null){
            save = entity;
            save.setCode(vo.getCode());
            save.setName(vo.getName());
            save.setSocialCreditCode(vo.getSocialCreditCode());
            save.setBusinessScope(vo.getBusinessScope());
            save.setTelephone(vo.getTelephone());
            save.setEnabled(vo.getEnabled());
            if(StringUtils.isNotEmpty(vo.getBankCode())){
                save.setBankName(vo.getBankName());
                save.setBankAccount(vo.getBankAccount());
                save.setBankCode(vo.getBankCode());
            }
            save.setGradeId(vo.getGradeId());
            save.setGradeName(vo.getGradeName());
            save.setTeamName(vo.getTeamName());
        }
        if (psrmRestUtil.isRunMode()) {
            PSRMResponse resp = supplierService.saveOrUpdatePsrmObj(vo);
            if (resp.isSuccess()) {
                save.setPsrmCode(resp.getPsrmCode());
                save.setPsrmReturncode(resp.getReturncode());
                save.setPsrmReturndata(JSONObject.toJSONString(resp));
            }
        }
        supplierService.saveOrUpdate(save, false);

        // 子表
        List<SupplierLinkerVO> linkerList = vo.getGridheaders();
        List<SupplierLinkerEntity> saveList = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(SupplierLinkerVO linker: linkerList) {
            if("add".equals(linker.getRowState())) {
                SupplierLinkerEntity data = BeanMapper.map(linker, SupplierLinkerEntity.class);
                data.setSupplierId(save.getId());
                saveList.add(data);
            }else if("edit".equals(linker.getRowState())) {
                SupplierLinkerEntity data = BeanMapper.map(linker, SupplierLinkerEntity.class);
                saveList.add(data);
            } else if("del".equals(linker.getRowState())) {
                deleteIds.add(linker.getId());
            }
        }
        if(saveList.size() > 0) {
            linkerService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        if(deleteIds.size() > 0) {
            linkerService.removeByIds(deleteIds, false);
        }
        return CommonResponse.success("执行成功！", BeanMapper.map(save, SupplierVO.class));
    }

    @RequestMapping(value = "saveOrUpdateBatch", method = RequestMethod.POST)
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<SupplierVO> vos) {
        List<SupplierEntity> saveList =  BeanMapper.mapList(vos, SupplierEntity.class);
        List<SupplierEntity> addList = new ArrayList<>();
        //1、校验数据是否已存在，存在则执行修改方法，否则执行新增方法
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("source_id", vos.stream().map(SupplierVO::getSourceId).collect(Collectors.toList()));
        List<SupplierEntity> list = supplierService.list(queryWrapper);
        Map<String, SupplierEntity> mapEntityMap = null;
        if (CollectionUtils.isNotEmpty(list)){
            mapEntityMap =  list.stream().collect(Collectors.toMap(SupplierEntity::getSourceId, (SupplierEntity e) -> e));
            for (SupplierEntity save : saveList){
                if (mapEntityMap.containsKey(save.getSourceId())){
                    SupplierEntity supplierEntity = mapEntityMap.get(save.getSourceId());
                    supplierEntity.setSocialCreditCode(save.getSocialCreditCode());
                    supplierEntity.setBusinessScope(save.getBusinessScope());
                    supplierEntity.setTelephone(save.getTelephone());
                    supplierEntity.setEnabled(save.getEnabled());
                    supplierEntity.setGradeId(save.getGradeId());
                    supplierEntity.setGradeName(save.getGradeName());
                    if(StringUtils.isNotEmpty(save.getBankCode())){
                        supplierEntity.setBankName(save.getBankName());
                        supplierEntity.setBankAccount(save.getBankAccount());
                        supplierEntity.setBankCode(save.getBankCode());
                    }
                    supplierEntity.setTeamName(save.getTeamName());
                    save = supplierEntity;
                }
                addList.add(save);
            }
        }else {
            addList.addAll(saveList);
        }
        supplierService.saveOrUpdateBatch(addList, addList.size());
        return CommonResponse.success("执行成功！");
    }





    /**
     * 删除
     *
     * @param sourceIds
     * @return
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<Long> sourceIds) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return CommonResponse.success("集合为空！");
        }
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("source_id", sourceIds);
        List<SupplierEntity> list = supplierService.list(queryWrapper);
        List<Long> ids = list.stream().map(SupplierEntity::getId).collect(Collectors.toList());
        if(ListUtil.isNotEmpty(ids)){
            for (Long id : ids) {
                CommonResponse<String>  response = billTypeService.checkQuote("BT200422000000028",id);
                if(!response.isSuccess()){
                    return CommonResponse.error("删除失败："+response.getMsg());
                }
            }
        }else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        if (psrmRestUtil.isRunMode()) {
            List<String> codes = list.stream().filter(t -> t.getPsrmCode() != null).map(SupplierEntity::getPsrmCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(codes)) {
                psrmRestUtil.disableOrDelObj(codes, PSRMMethodConsts.SUPPLIER_DISABLE);
            }
        }
        supplierService.deleteSupplier(ids);
        return CommonResponse.success("删除成功");
    }

    @GetMapping("getSupplierBySupplierTenantId")
    public CommonResponse<SupplierVO> getSupplierBySupplierTenantId(@RequestParam Long supplierTenantId){
        QueryParam param = new QueryParam();
        param.getParams().put("tenant", Parameter.getEqInstance(supplierTenantId));
        List<SupplierEntity> list = supplierService.queryList(param,false);
        SupplierVO res = null;
        if(ListUtil.isNotEmpty(list)){
            res = BeanMapper.map(list.get(0), SupplierVO.class);
        }
        return CommonResponse.success("查询成功！", res);
    }

    /**
     * 根据供应商编码查询供应商信息
     *
     * @param code 供应商编码
     * @return
     */
    @GetMapping("queryByCode")
    CommonResponse<SupplierVO> queryByCode(@RequestParam(value = "code") String code){
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("code", code);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            return CommonResponse.success("查询成功！", BeanMapper.map(entitys.get(0), SupplierVO.class));
        }
        return CommonResponse.success("根据编码未查询到该供应商！");
    }
}
