package com.ejianc.foundation.share.service.impl;

import java.util.List;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.mapper.SupplierCategoryMapper;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class SupplierCategoryServiceImpl extends BaseServiceImpl<SupplierCategoryMapper, SupplierCategoryEntity> implements ISupplierCategoryService {

	@Autowired
	private SupplierCategoryMapper supplierCategoryMapper;
	
	@Override
	public SupplierCategoryEntity queryDetail(Long id) {
		SupplierCategoryEntity entity = supplierCategoryMapper.selectById(id);
		return entity;
	}

	@Override
	public List<SupplierCategoryVO> queryListByPid(Long id) {
		QueryWrapper<SupplierCategoryEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("parent_id", id);
		List<SupplierCategoryEntity> entities = supplierCategoryMapper.selectList(wrapper);
		if(entities != null) {
			return BeanMapper.mapList(entities, SupplierCategoryVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		supplierCategoryMapper.deleteById(id);
	}

	@Override
	public SupplierCategoryVO queryByCode(String code) {
		QueryWrapper<SupplierCategoryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("code", code);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		List<SupplierCategoryEntity> list = supplierCategoryMapper.selectList(queryWrapper);
		if(list != null && list.size() > 0) {
			return BeanMapper.map(list.get(0), SupplierCategoryVO.class);
		}
		return null;
	}

}
