/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerLinkerService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.util.PSRMMethodConsts;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerLinkerVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/customer/"})
public class CustomerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CUSTOMER_BILL_CODE = "SUPPORT_CUSTOMER";
    @Autowired
    private IBillTypeService billTypeService;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private ICustomerCategoryService customerCategoryService;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private ICustomerLinkerService customerLinkerService;
    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private PSRMRestUtil psrmRestUtil;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody CustomerVO customerVo) {
        CommonResponse<String> response = this.customerService.saveOrUpdate(customerVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CustomerVO> queryDetail(@RequestParam Long id) {
        CustomerVO customerVo = this.customerService.queryDetail(id);
        JSONObject parent = new JSONObject();
        CustomerCategoryEntity e = (CustomerCategoryEntity)((Object)this.customerCategoryService.selectById(customerVo.getCategoryId()));
        parent.put("id", (Object)e.getId());
        parent.put("code", (Object)e.getCode());
        parent.put("name", (Object)e.getName());
        customerVo.setParent(parent);
        return CommonResponse.success((Object)customerVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> response = this.billTypeService.checkQuote("BT200422000000027", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        if (this.psrmRestUtil.isRunMode().booleanValue()) {
            List codes;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", ids);
            List list = this.customerService.list((Wrapper)queryWrapper);
            if (this.psrmRestUtil.isRunMode().booleanValue() && CollectionUtils.isNotEmpty(codes = list.stream().filter(t -> t.getPsrmCode() != null).map(CustomerEntity::getPsrmCode).collect(Collectors.toList()))) {
                this.psrmRestUtil.disableOrDelObj(codes, PSRMMethodConsts.CUSTOMER_DISABLE);
            }
        }
        this.customerService.deleteCustomer(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<CustomerVO> pageData = this.customerService.queryPageList(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"customer-import.xlsx", (String)"\u5ba2\u6237\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                CustomerVO customerVo = null;
                CustomerCategoryVO customerCategoryVo = this.customerCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (customerCategoryVo != null) {
                    DefdocDetailVO customerTypeVo;
                    DefdocDetailVO taxPayerTypeVo;
                    if (StringUtils.isEmpty((CharSequence)datas.get(2))) {
                        errorList.add("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    customerVo = this.customerService.queryDetailBySocialCode(String.valueOf(datas.get(2)));
                    if (customerVo != null) {
                        errorList.add("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u5ba2\u6237\uff01");
                        continue;
                    }
                    customerVo = new CustomerVO();
                    if (StringUtils.isEmpty((CharSequence)datas.get(1))) {
                        try {
                            String billCode = this.generator.generateBillCodeById(CUSTOMER_BILL_CODE, tenantId);
                            customerVo.setCode(billCode);
                        }
                        catch (BillCodeException e) {
                            customerVo.setCode(String.valueOf(new Date().getTime()));
                        }
                    } else {
                        customerVo.setCode(datas.get(1));
                    }
                    customerVo.setName(String.valueOf(datas.get(2)));
                    customerVo.setCategoryId(customerCategoryVo.getId());
                    customerVo.setSocialCreditCode(String.valueOf(datas.get(3)));
                    customerVo.setLegal(datas.get(4));
                    if (StringUtils.isNotEmpty((CharSequence)datas.get(5)) && (taxPayerTypeVo = this.defdocDetailService.queryDetailByName(String.valueOf(datas.get(5)))) != null) {
                        customerVo.setTaxPayerType(taxPayerTypeVo.getId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)datas.get(6)) && (customerTypeVo = this.defdocDetailService.queryDetailByName(String.valueOf(datas.get(6)))) != null) {
                        customerVo.setCustomerType(customerTypeVo.getId());
                    }
                    customerVo.setTelephone(datas.get(7));
                    customerVo.setAreaStr(datas.get(8));
                    customerVo.setBankName(datas.get(9));
                    customerVo.setBankAccount(datas.get(10));
                    customerVo.setBankCode(datas.get(11));
                    customerVo.setAddressAndPhone(datas.get(12));
                    if (StringUtils.isNotEmpty((CharSequence)datas.get(13))) {
                        ArrayList<CustomerLinkerVO> gridheaders = new ArrayList<CustomerLinkerVO>();
                        String linkman = String.valueOf(datas.get(13));
                        CustomerLinkerVO customerLinkerVo = this.customerLinkerService.queryByCustomerIdAndLinkman(customerVo.getId(), linkman);
                        if (customerLinkerVo == null) {
                            customerLinkerVo = new CustomerLinkerVO();
                            customerLinkerVo.setRowState("add");
                        } else {
                            customerLinkerVo.setRowState("edit");
                        }
                        customerLinkerVo.setCustomerId(customerVo.getId());
                        customerLinkerVo.setLinkman(datas.get(13));
                        customerLinkerVo.setCellphone(datas.get(14));
                        gridheaders.add(customerLinkerVo);
                        customerVo.setGridheaders(gridheaders);
                    }
                    this.customerService.saveOrUpdate(customerVo);
                    continue;
                }
                errorList.add("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5ba2\u6237\u5206\u7c7b\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size()) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<Object> customerVos = new ArrayList();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        customerVos = this.customerService.queryExportList(queryParam);
        HashMap beans = new HashMap();
        beans.put("records", customerVos);
        ExcelExport.getInstance().export("customer-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refer"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CustomerVO>> refer(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        JSONObject jsonObject;
        QueryParam queryParam = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            queryParam.getParams().put("categoryId", new Parameter("eq", (Object)categoryId));
        }
        if (StringUtils.isNotBlank((CharSequence)condition) && (jsonObject = JSON.parseObject((String)condition)).containsKey((Object)"insideFlag")) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq(CustomerCategoryEntity::getName, (Object)"\u5185\u90e8\u5ba2\u6237");
            List list = this.customerCategoryService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                queryParam.getParams().put("categoryId", new Parameter("eq", (Object)((CustomerCategoryEntity)((Object)list.get(0))).getId()));
            }
        }
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("socialCreditCode");
        IPage<CustomerVO> pageData = this.customerService.queryPageList(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", pageData);
    }
}

