/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.temporaryStorage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IParamRegisterSetService;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.foundation.temporaryStorage.bean.TemporaryStorageEntity;
import com.ejianc.foundation.temporaryStorage.service.ITemporaryStorageService;
import com.ejianc.foundation.temporaryStorage.vo.TemporaryStorageVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"temporaryStorage"})
public class TemporaryStorageController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ITemporaryStorageService service;
    @Autowired
    private IParamRegisterSetService paramRegisterSetService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemporaryStorageVO> saveOrUpdate(@RequestBody TemporaryStorageVO saveOrUpdateVO) {
        CommonResponse billTypeVO;
        TemporaryStorageEntity entity = new TemporaryStorageEntity();
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            entity = (TemporaryStorageEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), TemporaryStorageEntity.class));
        } else {
            entity = (TemporaryStorageEntity)((Object)this.service.getById(saveOrUpdateVO.getId()));
            entity.setBillData(saveOrUpdateVO.getBillData());
            entity.setType(saveOrUpdateVO.getType());
            entity.setPcurl(saveOrUpdateVO.getPcurl());
            entity.setMaurl(saveOrUpdateVO.getMaurl());
        }
        entity.setCreateUserId(InvocationInfoProxy.getUserid());
        entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        entity.setCreateTime(new Date());
        if (entity.getBillTypeId() == null && StringUtils.isNotBlank((CharSequence)entity.getBillTypeCode()) && (billTypeVO = this.billTypeApi.getByCode(entity.getBillTypeCode())).isSuccess() && billTypeVO.getData() != null) {
            entity.setBillTypeId(((BillTypeVO)billTypeVO.getData()).getId());
            entity.setBillTypeName(((BillTypeVO)billTypeVO.getData()).getBillName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        TemporaryStorageVO vo = (TemporaryStorageVO)((Object)BeanMapper.map((Object)((Object)entity), TemporaryStorageVO.class));
        ParamRegisterSetEntity paramRegisterSetEntity = this.paramRegisterSetService.getByCode("P-xQ51400179");
        if (paramRegisterSetEntity != null) {
            vo.setDay(paramRegisterSetEntity.getValueData());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TemporaryStorageVO> queryDetail(Long id) {
        TemporaryStorageEntity entity = (TemporaryStorageEntity)((Object)this.service.selectById(id));
        TemporaryStorageVO vo = (TemporaryStorageVO)((Object)BeanMapper.map((Object)((Object)entity), TemporaryStorageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemporaryStorageVO> vos) {
        this.service.deleteByIds(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/countTemporaryStorage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> countTemporaryStorage(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page.getTotal());
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemporaryStorageVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemporaryStorageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TemporaryStorage-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTemporaryStorageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TemporaryStorageVO>> refTemporaryStorageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemporaryStorageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/cleanStorageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> cleanStorageData() {
        QueryWrapper wapper = new QueryWrapper();
        wapper.eq((Object)"code", (Object)"P-xQ51400179");
        List list = this.paramRegisterSetService.list((Wrapper)wapper);
        ArrayList<TemporaryStorageVO> vos = new ArrayList<TemporaryStorageVO>();
        if (list != null && list.size() > 0) {
            ArrayList<Long> tenantIds = new ArrayList<Long>();
            String omsValueData = null;
            for (ParamRegisterSetEntity entity : list) {
                tenantIds.add(entity.getTenantId());
                if (entity.getTenantId().equals(999999L)) {
                    omsValueData = entity.getValueData();
                }
                Date date = TemporaryStorageController.getPastDate(Integer.parseInt(entity.getValueData()), new Date());
                QueryWrapper temporarywapper = new QueryWrapper();
                temporarywapper.eq((Object)"tenant_id", (Object)entity.getTenantId());
                temporarywapper.le((Object)"create_time", (Object)date);
                List temporarylist = this.service.list((Wrapper)temporarywapper);
                if (temporarylist == null || temporarylist.size() <= 0) continue;
                vos.addAll(BeanMapper.mapList((Iterable)temporarylist, TemporaryStorageVO.class));
            }
            if (tenantIds != null && tenantIds.size() > 0) {
                Date date = TemporaryStorageController.getPastDate(Integer.parseInt(omsValueData), new Date());
                QueryWrapper temporarywapper = new QueryWrapper();
                temporarywapper.notIn((Object)"tenant_id", tenantIds);
                temporarywapper.le((Object)"create_time", (Object)date);
                List temporarylist = this.service.list((Wrapper)temporarywapper);
                if (temporarylist != null && temporarylist.size() > 0) {
                    vos.addAll(BeanMapper.mapList((Iterable)temporarylist, TemporaryStorageVO.class));
                }
            }
        }
        if (vos != null && vos.size() > 0) {
            this.service.deleteByIds(vos);
        }
        return CommonResponse.success((String)"\u5b9a\u65f6\u6e05\u7406\u6570\u636e\u6210\u529f\uff01");
    }

    public static Date getPastDate(int pastDay, Date newDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        calendar.set(6, calendar.get(6) - pastDay);
        Date resultDate = calendar.getTime();
        return resultDate;
    }
}

