package com.ejianc.foundation.share.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.bean.ProjectEntity;
import com.ejianc.foundation.share.mapper.ProjectMapper;
import com.ejianc.foundation.share.service.IProjectService;
import com.ejianc.foundation.share.vo.ProjectPriceVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

import javax.management.Query;

/**
 * 项目
 * 
 * @author generator
 * 
 */
@Service("projectService")
public class ProjectServiceImpl extends BaseServiceImpl<ProjectMapper, ProjectEntity> implements IProjectService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "project";//此处需要根据实际修改
    private static final String BILL_TYPE_CODE = "BT211209000000001";//此处需要根据实际修改
    
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ProjectMapper projectMapper;

	@Override
	public ProjectVO temporarySave(ProjectVO saveorUpdateVO) {
    	ProjectEntity entity = BeanMapper.map(saveorUpdateVO, ProjectEntity.class);
        this.checkProject(entity);
    	ProjectVO vo = this.save(entity, saveorUpdateVO);
    	return vo;
	}

    private void checkProject(ProjectEntity entity){
        //唯一性校验
        QueryWrapper<ProjectEntity> wrapper = new QueryWrapper<>();
        if(entity.getId() != null){
            wrapper.ne("id", entity.getId());
        }
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        wrapper.eq("project_name", entity.getProjectName());
        List<ProjectEntity> check = this.list(wrapper);
        if(check!=null && check.size()>0){
            throw new BusinessException("项目名称已存在！！！");
        }
    }
	@Override
	public ProjectVO saveData(ProjectVO saveorUpdateVO) {
    	ProjectEntity entity = BeanMapper.map(saveorUpdateVO, ProjectEntity.class);
        this.checkProject(entity);
    	OrgVO projectDepartment = null;
    	if(entity.getId() == null || entity.getId() == 0){
            //生成项目部组织
    		projectDepartment = this.generateProjectDepartment(saveorUpdateVO);
        }else{
        	if(saveorUpdateVO.getProjectDepartmentId()!=null){
                projectDepartment = (OrgVO) getRespData(orgApi.getOneById(entity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                if(!saveorUpdateVO.getOrgId().equals(projectDepartment.getId())) {
                    //项目所属组织修改
                    projectDepartment.setParentId(saveorUpdateVO.getOrgId());
                }
                if(!saveorUpdateVO.getProjectName().equals(projectDepartment.getName())) {
                    projectDepartment.setName(saveorUpdateVO.getProjectName());
                    projectDepartment.setShortName(saveorUpdateVO.getProjectName());
                }
        	}else{
                //生成项目部组织
        		projectDepartment = this.generateProjectDepartment(saveorUpdateVO);
        	}
        }
    	if(projectDepartment!=null){
    		//保存更新项目部信息
            if("2".equals(entity.getStatus())){
                projectDepartment.setProjectState(1);
            }else{
                projectDepartment.setProjectState(2);
            }
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，保存项目部信息出错: " + resp.getMsg());
            }
            entity.setProjectDepartmentId(projectDepartment.getId());
    	}
        ProjectVO vo = new ProjectVO();
        try{
            Map<String, Object> memberMap = getMemberMap(saveorUpdateVO);
            if(!memberMap.isEmpty()) {
                //保存新增的成员信息
                CommonResponse<String> resp = employeeApi.manageProjectMembers(memberMap);
                if(!resp.isSuccess()) {
                    logger.info("保存失败，新增成员出错: {}",resp.getMsg());
                    throw new BusinessException("保存失败，新增成员出错: " + resp.getMsg());
                }
            }
            vo = this.save(entity, saveorUpdateVO);
        }catch (Exception e){
            if(entity.getProjectDepartmentId()!=null){
                orgApi.delById(entity.getProjectDepartmentId());
            }
            throw new BusinessException("保存项目信息失败！！！");
        }
    	return vo;
	}
	
    private Map<String, Object> getMemberMap(ProjectVO projectRegisterVO) {
        Map<String, Object> dataMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectRegisterVO.getMembersList())) {
            //保存项目成员
            Map<String, Object> moveMap = new HashMap<>(), parttimeMap = new HashMap<>();

            List<RoleUserRelationVO> relationList = null;
            RoleUserRelationVO tmp = null;
            for(Map<String, Object> member :  projectRegisterVO.getMembersList()) {
                //过滤掉非新增的成员
                if(null != member.get("isAdd") && "true".equals(member.get("isAdd"))) {
                    tmp = new RoleUserRelationVO();
                    tmp.setUserId(null != member.get("userId") ? Long.valueOf(member.get("userId").toString()) : null);
                    tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                    tmp.setAuthOrgId(projectRegisterVO.getProjectDepartmentId());
                    tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                    tmp.setRoleId(null != member.get("roleId") ? Long.valueOf(member.get("roleId").toString()) : null);
                    if("move".equals(member.get("type").toString())) {
                        relationList = (List<RoleUserRelationVO>) moveMap.get(tmp.getEmployeeId());
                        if(null == relationList) {
                            relationList = new ArrayList<>();
                        }
                        relationList.add(tmp);
                        moveMap.put(tmp.getEmployeeId().toString(), relationList);
                    } else {
                        relationList = (List<RoleUserRelationVO>) parttimeMap.get(tmp.getEmployeeId());
                        if(null == relationList) {
                            relationList = new ArrayList<>();
                        }
                        relationList.add(tmp);
                        parttimeMap.put(tmp.getEmployeeId().toString(), relationList);
                    }
                }
            }
            if(!moveMap.isEmpty()) {
                Map<String, Object> moveData = new HashMap<>();
                moveData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                moveData.put("detail", moveMap);
                dataMap.put("moveMembers", moveData);
            }
            if(!parttimeMap.isEmpty()) {
                Map<String, Object> parttimeData = new HashMap<>();
                parttimeData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                parttimeData.put("detail", parttimeMap);
                dataMap.put("parttimeMembers", parttimeData);
            }
        }

        return dataMap;
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 生成项目对应的项目部信息
     *
     * @param projectVO
     * @return
     */
    private OrgVO generateProjectDepartment(ProjectVO projectVO) {
        CommonResponse<OrgVO> response = orgApi.getOneById(projectVO.getOrgId());
        OrgVO parentOrg = null;
        if(response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            throw new BusinessException("保存项目信息失败，查询项目所属组织信息失败: " + response.getMsg() );
        }
        if(null == parentOrg) {
            throw new BusinessException("保存项目信息失败，项目所属组织信息不存在。");
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(IdWorker.getId());
        projectDepartment.setParentId(projectVO.getOrgId());
        projectDepartment.setTenantId(parentOrg.getTenantId());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setIsParent(false);
        projectDepartment.setName(projectVO.getProjectName());
        projectDepartment.setShortName(projectVO.getProjectName());
        projectDepartment.setState(1);
        //项目部类型
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);

        return projectDepartment;
    }

    public ProjectVO save(ProjectEntity entity,ProjectVO saveorUpdateVO){
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setState(1);//启用
        }
    	if(saveorUpdateVO.getProjectPriceList()!=null&&saveorUpdateVO.getProjectPriceList().size()>0){
    		ProjectPriceVO projectPriceVO = saveorUpdateVO.getProjectPriceList().get(0);
    	    entity.setProjectBidWinPrice(projectPriceVO.getProjectBidWinPrice());
    	    entity.setCivilEngineering(projectPriceVO.getCivilEngineering());
    	    entity.setFix(projectPriceVO.getFix());
    	    entity.setWaterSupplyDrainage(projectPriceVO.getWaterSupplyDrainage());
    	    entity.setStrongCurrent(projectPriceVO.getStrongCurrent());
    	    entity.setHeateVentilation(projectPriceVO.getHeateVentilation());
    	    entity.setFixOther(projectPriceVO.getFixOther());
    	    entity.setDecorate(projectPriceVO.getDecorate());
    	    entity.setOther(projectPriceVO.getOther());
    	}else{
    	    entity.setProjectBidWinPrice(null);
    	    entity.setCivilEngineering(null);
    	    entity.setFix(null);
    	    entity.setWaterSupplyDrainage(null);
    	    entity.setStrongCurrent(null);
    	    entity.setHeateVentilation(null);
    	    entity.setFixOther(null);
    	    entity.setDecorate(null);
    	    entity.setOther(null);
    	}
    	this.saveOrUpdate(entity, false);
    	ProjectVO vo = BeanMapper.map(entity, ProjectVO.class);
    	vo.setProjectPriceList(saveorUpdateVO.getProjectPriceList());
    	return vo;
    }

    @Override
    public CommonResponse<String> changeState(ProjectVO projectVO) {
        ProjectEntity e = super.selectById(projectVO.getId());
        CommonResponse<OrgVO> orgResp = orgApi.getOneById(e.getProjectDepartmentId());
        if(!orgResp.isSuccess()) {
            throw new BusinessException("更改项目状态失败，获取项目部信息失败！");
        }
        OrgVO department = orgResp.getData();
        String msg = "";
        if(projectVO.getState() == 1) {
            //停用
            department.setState(0);
            e.setState(0);
            msg = "停用成功！";
        } else if(projectVO.getState() == 0) {
            //启用
            department.setState(1);
            e.setState(1);
            msg = "启用成功";
        } else {
            throw new BusinessException("更改项目状态失败，非法的项目状态！");
        }
        CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(department);
        if(!resp.isSuccess()) {
            throw new BusinessException("更改项目状态失败失败，更新项目部信息出错: " + resp.getMsg());
        }
        super.saveOrUpdate(e);
        return CommonResponse.success(msg);
    }

	@Override
	public CommonResponse<String> delProject(List<ProjectVO> vos) {
		String userType = InvocationInfoProxy.getUserType();
		if(!"1".equals(userType)) {
			logger.info("组织删除操作终止，当前登陆人[userId-{}]无删除权限。---------", InvocationInfoProxy.getUserid());
			return CommonResponse.error("该用户没有删除权限，请联系超级管理员执行删除操作。");
		}

		List<ProjectVO> list = new ArrayList<>();
		for(ProjectVO vo : vos){
			ProjectEntity entity = this.selectById(vo.getId());
			vo = BeanMapper.map(entity, ProjectVO.class);
			list.add(vo);
	        if("1".equals(vo.getState())) {
	            return CommonResponse.error("删除失败，项目：【"+vo.getProjectName()+"】为启用状态不可删除！");
	        }
	        //引用查询，若该项目已被下游引用，则无法进行删除操作
	        CommonResponse<String> resp = billTypeApi.checkQuote(BILL_TYPE_CODE, vo.getId());
	        if(!resp.isSuccess()) {
	            logger.info("项目立项【Id-{}】无法进行删除操作，原因：{}", vo.getId(), resp.getMsg());
	            return CommonResponse.error("项目："+vo.getProjectName()+"引用检查失败,"+resp.getMsg()+"，删除操作中止.");
	        }
		}
		for(ProjectVO vo : list){
            logger.info("执行项目删部除操作，删除项目部[id-{}]", vo.getProjectDepartmentId());
            //删除对应项目部相关信息
            CommonResponse<String> delResp = orgApi.delByOrgId(vo.getProjectDepartmentId());
            if(!delResp.isSuccess()) {
                logger.error("删除项目[id-{}]对应项目部[id-{}]信息失败，原因：{}", vo.getId(), vo.getProjectDepartmentId(), delResp.getMsg());

                return CommonResponse.error("项目["+vo.getProjectName()+"]删除失败，删除对应项目部信息失败。");
            }
        }

        this.removeByIds(list.stream().map(ProjectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
	}

    /**
     * 查询项目数量
     * @return
     */
    public Integer queryProjectNum(String signValue) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return projectMapper.queryProjectCount(tenantId,signValue);
    }
}
