/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.MaterialAuditEntity;
import com.ejianc.foundation.share.service.IMaterialAuditService;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialAuditDetailVO;
import com.ejianc.foundation.share.vo.MaterialAuditVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialAudit"})
public class MaterialAuditController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialAuditService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IBillTypeService billTypeService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IBillCodeGenerator generator;
    private static final String MATERIAL_AUDIT_BILL_CODE = "SUPPORT_MATERIAL_AUDIT";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialAuditVO> saveOrUpdate(@RequestBody MaterialAuditVO auditVO) throws BillCodeException {
        List materialAuditDetailList = auditVO.getMaterialAuditDetailList();
        ArrayList<String> materialNames = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)materialAuditDetailList)) {
            if ("\u65b0\u589e".equals(auditVO.getOptFlag())) {
                HashMap distinctCodeMap = new HashMap();
                for (MaterialAuditDetailVO materialVo : materialAuditDetailList) {
                    MaterialVO codeData;
                    if ("del".equals(materialVo.getRowState())) continue;
                    String code = materialVo.getCode();
                    if (distinctCodeMap.containsKey(code)) {
                        throw new BusinessException("\u8be5\u5355\u636e\u660e\u7ec6\u4e2d\u7269\u6599\u7f16\u7801\u3010" + code + "\u3011\u91cd\u590d\uff01");
                    }
                    distinctCodeMap.put(code, materialVo);
                    MaterialVO materialBean = this.materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialVo.getCategoryId());
                    if (materialBean != null) {
                        throw new BusinessException("\u8be5\u7269\u6599\u7f16\u7801\u3010" + code + "\u3011\u5728\u7269\u6599\u6863\u6848\u5206\u7c7b\u3010" + materialVo.getCategoryName() + "\u3011\u4e0b\u5df2\u7ecf\u6709\u76f8\u540c\u540d\u79f0\u3001\u5355\u4f4d\u3001\u89c4\u683c\u578b\u53f7\u7684\u7269\u6599\uff01");
                    }
                    if (!StringUtils.isNotBlank((CharSequence)code) || (codeData = this.materialService.queryByCode(code)) == null) continue;
                    throw new BusinessException("\u8be5\u7269\u6599\u7f16\u7801\u3010" + code + "\u3011\u5728\u7269\u6599\u6863\u6848\u4e2d\u5df2\u5b58\u5728\uff01");
                }
            }
            for (MaterialAuditDetailVO materialAuditDetailVO : materialAuditDetailList) {
                if ("del".equals(materialAuditDetailVO.getRowState())) continue;
                if (materialAuditDetailVO.getMaterialId() == null) {
                    materialAuditDetailVO.setMaterialId(Long.valueOf(IdWorker.getId()));
                }
                materialNames.add(materialAuditDetailVO.getName());
            }
        }
        if (CollectionUtils.isNotEmpty(materialNames)) {
            auditVO.setMaterialNames(StringUtils.join(materialNames, (String)"\u3001"));
        } else {
            auditVO.setMaterialNames(null);
        }
        if (StringUtils.isBlank((CharSequence)auditVO.getBillCode())) {
            String billCode = this.generator.generateBillCodeById(MATERIAL_AUDIT_BILL_CODE, InvocationInfoProxy.getTenantid());
            auditVO.setBillCode(billCode);
        }
        MaterialAuditEntity entity = (MaterialAuditEntity)((Object)BeanMapper.map((Object)auditVO, MaterialAuditEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        MaterialAuditVO vo = (MaterialAuditVO)BeanMapper.map((Object)((Object)entity), MaterialAuditVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialAuditVO> queryDetail(Long id) {
        MaterialAuditEntity entity = (MaterialAuditEntity)((Object)this.service.selectById(id));
        MaterialAuditVO vo = (MaterialAuditVO)BeanMapper.map((Object)((Object)entity), MaterialAuditVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialAuditVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialAuditVO materialAuditVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialAuditVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "theme", "materialNames", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialAuditVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "theme", "materialNames", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("MaterialAudit-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialAuditData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialAuditVO>> refMaterialAuditData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialAuditVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

