package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 供方
 *
 * @author guoming
 *
 */
@TableName("ejc_support_supplier")
public class SupplierEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "code")
	private String code; // 供方编码

	@TableField(value = "name")
	private String name; // 供方名称

	@TableField(value = "category_id")
	private Long categoryId; // 供方分类ID

	@TableField(exist = false)
	private String categoryName; // 供方分类名称

	@TableField(value = "social_credit_code")
	private String socialCreditCode; // 社会信用代码

	@TableField(value = "legal")
	private String legal; // 法定代表人

	@TableField(value = "tax_payer_type")
	private Long taxPayerType; // 纳税人类型

	@TableField(value = "business_scope")
	private String businessScope; // 经营范围

	@TableField(value = "enabled")
	private Integer enabled; // 合作不合作（1：合作 ， 0：不合作）

	@TableField(value = "area")
	private String area; // 地区

	@TableField(value = "address")
	private String address; // 详细地址

	@TableField(value = "telephone")
	private String telephone; // 客户电话

	@TableField(value = "bank_name")
	private String bankName; // 账户名

	@TableField(value = "bank_account")
	private String bankAccount;// 银行账号

	@TableField(value = "bank_code")
	private String bankCode; // 开户行

	@TableField(value = "description")
	private String description; // 描述

	@TableField(value = "source_id")
	private String sourceId; // 来源id

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "tenant")
	private Long tenant; // 关联租户id（供方协同）

	@TableField(value = "tenant_name")
	private String tenantName; // 关联租户名称（供方协同）

	@TableField(value = "tenant_phone")
	private String tenantPhone; // 生成租户手机号（供方协同）

	@TableField(value = "tenant_user_name")
	private String tenantUserName; // 生成租户管理员名称（供方协同）

	@TableField(value = "tenant_user_id")
	private Long tenantUserId; // 生成租户管理员id（供方协同）

	@TableField(value="team_name")
	private String teamName; // 班组名称

	/**
	 * 省份
	 */
	@TableField(value = "province")
	private String province;

	/**
	 * 市区
	 */
	@TableField(value = "city")
	private String city;

	/**
	 * 区县
	 */
	@TableField(value = "region")
	private String region;

	@TableField(value = "grade_id")
	private Long gradeId; // 供应商等级 自定义档案

	@TableField(value = "grade_name")
	private String gradeName; // 供应商等级 自定义档案

	@TableField(value = "area_str")
	private String areaStr; // 详细地址

	@TableField(value = "psrm_returncode")
	private String psrmReturncode; // 数据中台状态

	@TableField(value = "psrm_code")
	private String psrmCode; // 数据中台编码

	@TableField(value = "psrm_returndata")
	private String psrmReturndata; // 数据中台返回数据

	public String getPsrmReturncode() {
		return psrmReturncode;
	}

	public void setPsrmReturncode(String psrmReturncode) {
		this.psrmReturncode = psrmReturncode;
	}

	public String getPsrmCode() {
		return psrmCode;
	}

	public void setPsrmCode(String psrmCode) {
		this.psrmCode = psrmCode;
	}

	public String getPsrmReturndata() {
		return psrmReturndata;
	}

	public void setPsrmReturndata(String psrmReturndata) {
		this.psrmReturndata = psrmReturndata;
	}

	public String getAreaStr() {
		return areaStr;
	}

	public void setAreaStr(String areaStr) {
		this.areaStr = areaStr;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getLegal() {
		return legal;
	}

	public void setLegal(String legal) {
		this.legal = legal;
	}

	public Long getTaxPayerType() {
		return taxPayerType;
	}

	public void setTaxPayerType(Long taxPayerType) {
		this.taxPayerType = taxPayerType;
	}

	public String getBusinessScope() {
		return businessScope;
	}

	public void setBusinessScope(String businessScope) {
		this.businessScope = businessScope;
	}

	public Integer getEnabled() {
		return enabled;
	}

	public void setEnabled(Integer enabled) {
		this.enabled = enabled;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public Long getTenant() {
		return tenant;
	}

	public void setTenant(Long tenant) {
		this.tenant = tenant;
	}

	public String getTenantName() {
		return tenantName;
	}

	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	public String getTenantPhone() {
		return tenantPhone;
	}

	public void setTenantPhone(String tenantPhone) {
		this.tenantPhone = tenantPhone;
	}

	public String getTenantUserName() {
		return tenantUserName;
	}

	public void setTenantUserName(String tenantUserName) {
		this.tenantUserName = tenantUserName;
	}

	public Long getTenantUserId() {
		return tenantUserId;
	}

	public void setTenantUserId(Long tenantUserId) {
		this.tenantUserId = tenantUserId;
	}

	public String getTeamName() {
		return teamName;
	}

	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public Long getGradeId() {
		return gradeId;
	}

	public void setGradeId(Long gradeId) {
		this.gradeId = gradeId;
	}

	public String getGradeName() {
		return gradeName;
	}

	public void setGradeName(String gradeName) {
		this.gradeName = gradeName;
	}
}
