package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.mapper.BillCodeRuleMapper;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("billTypeRuleService")
public class BillCodeRuleServiceImpl extends BaseServiceImpl<BillCodeRuleMapper, BillCodeRuleEntity> implements IBillCodeRuleService {

    @Autowired
    private IBillCodeRuleAttrService billCodeRuleAttrService;

    @Value("${oms.tenantid}")
    private String BASE_TNANT_ID;

    @Override
    public void delete(List<Long> ids) {
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public BillCodeRuleVO queryDetail(Long id) {
    	Long tenantId = InvocationInfoProxy.getTenantid();
        BillCodeRuleVO vo = null;
        BillCodeRuleEntity entity = baseMapper.selectById(id);
        if(entity != null) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    private void queryAttrDetail(BillCodeRuleVO vo, Long tenantId) {
        //先查询本租户下的编码规则属性
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter(QueryParam.EQ, vo.getId()));
        q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        q.getOrderMap().put("elem_order", QueryParam.ASC);
        List<BillCodeRuleAttrVO> attrs = billCodeRuleAttrService.getListByProperties(q, false);
        if(CollectionUtils.isEmpty(attrs)) {
            //若本租户下的编码规则属性为空，则查询公共编码规则属性
            q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, BASE_TNANT_ID));
            attrs = billCodeRuleAttrService.getListByProperties(q, false);
        }
        vo.setAttrs(attrs);
    }
    
    private void queryAttrDetail(BillCodeRuleVO vo, BillCodeParam billCodeParam) {
        //先查询本租户下的编码规则属性
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter(QueryParam.EQ, vo.getId()));
        q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, billCodeParam.getTenantId()));
        q.getOrderMap().put("elem_order", QueryParam.ASC);
        List<BillCodeRuleAttrVO> attrs = billCodeRuleAttrService.getListByProperties(q, false);
        if(CollectionUtils.isEmpty(attrs)) {
            //若本租户下的编码规则属性为空，则查询公共编码规则属性
            q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, BASE_TNANT_ID));
            attrs = billCodeRuleAttrService.getListByProperties(q, false);
        }
        if(attrs != null && attrs.size() > 0) {
        	JSONObject billDetail = billCodeParam.getBillDetail();
        	if(billDetail != null) {
        		for(BillCodeRuleAttrVO billCodeRuleAttrVO:attrs) {
        			String key = billCodeRuleAttrVO.getElemValue().trim();
        			String billValue = billDetail.getString(key);
        			if(StringUtils.isNotBlank(billValue)) {
        				billCodeRuleAttrVO.setBillValue(billValue);
        			}
        		}
        	}
        }
        vo.setAttrs(attrs);
    }

    @Override
    public void save(BillCodeRuleVO billCodeRuleVo) {
        BillCodeRuleEntity saveEntity = null;
        List<BillCodeRuleAttrVO> attrs = new ArrayList<>();
        if(null != billCodeRuleVo.getId()) {
            //更新
            attrs = billCodeRuleVo.getAttrs();

            saveEntity = baseMapper.selectById(billCodeRuleVo.getId());
            saveEntity.setRuleName(billCodeRuleVo.getRuleName());
            super.saveOrUpdate(saveEntity);
        } else {
            //新增
            billCodeRuleVo.setDr(BaseVO.DR_UNDELETE);
            billCodeRuleVo.setTenantId(InvocationInfoProxy.getTenantid());
            saveEntity = BeanMapper.map(billCodeRuleVo, BillCodeRuleEntity.class);
            super.saveOrUpdate(saveEntity);

            attrs = billCodeRuleVo.getAttrs();
        }

        if(CollectionUtils.isNotEmpty(attrs)) {
            //更新对应子元素：全部删除，重新新增
            billCodeRuleAttrService.save(attrs, saveEntity.getId(), true);
        }
    }

    @Override
    public BillCodeRuleVO queryDetail(String ruleCode) {
        BillCodeRuleVO vo = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryWrapper<BillCodeRuleEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("rule_code", ruleCode);
        query.eq("tenant_id", BASE_TNANT_ID);
        BillCodeRuleEntity entity = baseMapper.selectOne(query);
        if(null != entity) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

	@Override
	public BillCodeRuleVO queryDetailByCodeAndTenantId(String code, Long tenantId) {
		BillCodeRuleVO vo = null;
		QueryWrapper<BillCodeRuleEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("rule_code", code);
        query.eq("tenant_id", BASE_TNANT_ID);
        BillCodeRuleEntity entity = baseMapper.selectOne(query);
        if(entity != null) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo,tenantId);
        }
        return vo;
	}

	@Override
	public BillCodeRuleVO queryBillCodeDetail(BillCodeParam billCodeParam) {
		BillCodeRuleVO vo = null;
		QueryWrapper<BillCodeRuleEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("rule_code", billCodeParam.getRuleCode());
        query.eq("tenant_id", BASE_TNANT_ID);
        BillCodeRuleEntity entity = baseMapper.selectOne(query);
        if(entity != null) {
            vo = BeanMapper.map(entity, BillCodeRuleVO.class);
            queryAttrDetail(vo, billCodeParam);
        }
        return vo;
	}

}
