package com.ejianc.foundation.share.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.vo.MaterialVO;

@Mapper
public interface MaterialMapper {

	List<MaterialEntity> queryListByCategoryId(@Param("tenantId") Long tenantId,@Param("categoryId") Long categoryId);

	List<MaterialEntity> queryList(Map<String, Object> condition);

	Long queryCount(Map<String, Object> condition);

	MaterialEntity queryDetail(@Param("tenantId") Long tenantId, @Param("id") Long id);

	void save(MaterialVO materialVo);

	void insertBatch(@Param("tenantId") Long tenantId,@Param("list") List<MaterialVO> list);

	void update(MaterialVO uniqueBean);

	void delete(@Param("tenantId") Long tenantId, @Param("id") Long id);

	MaterialVO queryExitFlag(@Param("tenantId") Long tenantId, @Param("name") String name,@Param("spec") String spec,@Param("unitName") String unitName,@Param("categoryId") Long categoryId);

	MaterialVO queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);

	List<MaterialEntity> queryExportList(Map<String, Object> condition);

	void insertMaterialListFromPlatform(@Param("tenantId") Long tenantId);

	List<MaterialEntity> queryRefMaterialList(Map<String, Object> params);

	Long queryRefMaterialCount(Map<String, Object> params);

	MaterialEntity queryBySourceId(@Param("sourceId") String sourceId,@Param("tenantId") Long tenantId);

	List<MaterialEntity> queryMaterialByIds(@Param("ids") List<Long> ids, @Param("tenantId") Long tenantId);


    List<MaterialEntity> queryZjwjRefMaterialList(Map<String, Object> params);

	Long queryZjwjRefMaterialCount(Map<String, Object> params);
}
