package com.ejianc.foundation.share.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.QueryParam;

public interface IMaterialService {

	/**
	 * 根据分类ID查询其下物料
	 *
	 * @param categoryId
	 * @return
	 */
	List<MaterialVO> queryListByCategoryId(Long categoryId);

	/**
	 * 查询详情
	 *
	 * @param id
	 * @return
	 */
	MaterialVO queryDetail(Long id);

	/**
	 * 修改
	 *
	 * @param uniqueBean
	 */
	void update(MaterialVO uniqueBean);

	/**
	 * 保存
	 *
	 * @param materialVo
	 */
	void save(MaterialVO materialVo);

	/**
	 * 批量保存
	 *
	 * @param materialVo
	 */
	void insertBatch(List<MaterialVO> materialVo);

	/**
	 * 删除
	 *
	 * @param ids
	 */
	void delete(List<Long> ids);

	/**
	 * 查询翻页
	 *
	 * @param queryParam
	 * @return
	 */
	IPage<MaterialEntity> queryPage(QueryParam queryParam);

	/**
	 * 查询是否已经存在
	 *
	 * @param name
	 * @param spec
	 * @param unitName
	 * @return
	 */
	MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId);

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	MaterialVO queryByCode(String code);

	/**
	 * 查询列表
	 *
	 * @param queryParam
	 * @return
	 */
	List<MaterialEntity> queryList(QueryParam queryParam);

	/**
	 * 从平台中拷贝
	 */
	void insertMaterialListFromPlatform();

	/**
	 * 查询材料参照
	 *
	 * @param params
	 * @return
	 */
	IPage<MaterialEntity> queryRefMaterialPage(Map<String, Object> params);

	/**
	 * 根据sourceId查询物资详情
	 *
	 * @param sourceId
	 * @return
	 */
	MaterialEntity queryBySourceId(String sourceId);

	/**
	 * 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 *
	 * @param ids
	 * @return
	 */
	List<MaterialEntity> queryMaterialByIds(List<Long> ids);

    IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params);
}
