package com.ejianc.foundation.support.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.service.IBankdocService;
import com.ejianc.foundation.support.vo.BankdocVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.support.bean.BankdocDetailEntity;
import com.ejianc.foundation.support.service.IBankdocDetailService;
import com.ejianc.foundation.support.vo.BankdocDetailVO;

/**
 * 银行档案实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("bankdocDetail")
public class BankdocDetailController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBankdocDetailService bankdocDetailService;

    @Autowired
    private IBankdocService bankdocService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BankdocDetailVO> saveOrUpdate(@RequestBody BankdocDetailVO saveorUpdateVO) {
        BankdocDetailEntity entity = BeanMapper.map(saveorUpdateVO, BankdocDetailEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        bankdocDetailService.saveOrUpdate(entity, false);
        BankdocDetailVO vo = BeanMapper.map(entity, BankdocDetailVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankdocDetailVO> queryDetail(Long id) {
        BankdocDetailEntity entity = bankdocDetailService.selectById(id);
        BankdocDetailVO vo = BeanMapper.map(entity, BankdocDetailVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */

    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        //先查询该档案项有没有子节点
        List<BankdocDetailVO> bankdocDetails = bankdocDetailService.queryListByPid(id);
        if (bankdocDetails != null && bankdocDetails.size() > 0) {
            return CommonResponse.error("删除失败！银行账户[xxxx]已使用，不允许删除");
        } else {
            bankdocDetailService.delete(id);
            return CommonResponse.success("删除成功");
        }
    }

    /**
     * 查询列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<BankdocDetailEntity> dataList = bankdocDetailService.queryList(queryParam);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success(jsonObject);
    }

    @GetMapping("/detailListByBankdocCode")
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryDetailListByBankdocCode(@RequestParam String bankdocTypeCode,
                                                                                 @RequestParam(value = "condition", required = false) String condition) {
        BankdocVO bankdocVo = bankdocService.queryUniqueByCode(bankdocTypeCode);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (org.apache.commons.lang.StringUtils.isNotBlank(condition) && !"null".equals(condition)) {
            JSONObject jsonParam = JSONObject.parseObject(condition);
            if (null != jsonParam.get("tenantId")) {
                tenantId = Long.valueOf(jsonParam.get("tenantId").toString());
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("bankdocId", new Parameter(QueryParam.EQ, bankdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        List<BankdocDetailEntity> dataList = bankdocDetailService.queryList(queryParam);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
    }
        /**
         * 更新父节点状态，同时更新子节点状态
         *
         * @param id
         * @return
         */
        @RequestMapping(value = "/enabled/update", method = RequestMethod.POST)
        @ResponseBody
        public CommonResponse<String> updateEnabled (@RequestBody BankdocDetailVO bankdocDetailVo){
            bankdocDetailService.updateEnabled(bankdocDetailVo);
            return CommonResponse.success("更新成功");
        }

        /**
         * @Description 导出
         * @param param
         * @Return void
         */
        @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
        @ResponseBody
        public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
            param.setPageIndex(1);
            param.setPageSize(-1);
            /** 数据隔离 本下 没有组织orgId的删除下面代码 */
            param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            List<BankdocDetailEntity> list = bankdocDetailService.queryList(param);
            //todo:字段翻译等等
            Map<String, Object> beans = new HashMap<>();
            beans.put("records", list);
            ExcelExport.getInstance().export("BankdocDetail-export.xlsx", beans, response);
        }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
        @RequestMapping(value = "/download")
        @ResponseBody
        public void download(HttpServletRequest request, HttpServletResponse response){
            ImportTemplate.initialize(response);
            ImportTemplate.templetdownload(request, "customer-import.xlsx", "客户导入模板");
        }

    /**
         * @Description 参照
         * @param param
         * @Return void
         */
        @RequestMapping(value = "/refBankdocDetailData", method = RequestMethod.GET)
        @ResponseBody
        public CommonResponse<IPage<BankdocDetailVO>> refBankdocDetailData (@RequestParam Integer
        pageNumber, @RequestParam Integer pageSize,
                String condition,
                String searchObject,
                String searchText){
            QueryParam param = new QueryParam();
            param.setPageSize(pageSize);
            param.setPageIndex(pageNumber);
            param.setSearchText(searchText);
            param.setSearchObject(searchObject);
            /** 租户隔离 */
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            if (StringUtils.isNotEmpty(condition)) {
                /** 处理condition */
                JSONObject _con = JSONObject.parseObject(condition);
            }

            IPage<BankdocDetailEntity> page = bankdocDetailService.queryPage(param, false);
            IPage<BankdocDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankdocDetailVO.class));

            return CommonResponse.success("查询参照数据成功！", pageData);
        }
    }