/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BankdocEntity;
import com.ejianc.foundation.support.service.IBankdocDetailService;
import com.ejianc.foundation.support.service.IBankdocService;
import com.ejianc.foundation.support.vo.BankdocDetailVO;
import com.ejianc.foundation.support.vo.BankdocVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bankdoc"})
public class BankdocController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBankdocService bankdocService;
    @Autowired
    private IBankdocDetailService bankdocDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BankdocVO> saveOrUpdate(@RequestBody BankdocVO saveorUpdateVO) {
        BankdocEntity entity = (BankdocEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), BankdocEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.bankdocService.saveOrUpdate((Object)entity, false);
        BankdocVO vo = (BankdocVO)((Object)BeanMapper.map((Object)((Object)entity), BankdocVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankdocVO> queryDetail(@RequestParam Long id) {
        BankdocVO bankdocVo = this.bankdocService.queryDetail(id);
        return CommonResponse.success((Object)((Object)bankdocVo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (!this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        List<BankdocDetailVO> bankdocDetails = this.bankdocDetailService.queryListByBankdocId(ids);
        if (bankdocDetails != null && bankdocDetails.size() > 0) {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff01\u8be5\u94f6\u884c\u7c7b\u522b\u5df2\u5b58\u5728\u94f6\u884c\u6863\u6848\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.bankdocService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.bankdocService.queryPage(queryParam, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/list/ref"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BankdocEntity>> ref(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        Map param = queryParam.getParams();
        param.put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        if (!StringUtils.isEmpty((String)searchText)) {
            param.put("name", new Parameter("like", (Object)searchText));
        }
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.bankdocService.queryPage(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", (Object)pageData);
    }
}

