/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BankdocDetailEntity;
import com.ejianc.foundation.support.service.IBankdocDetailService;
import com.ejianc.foundation.support.service.IBankdocService;
import com.ejianc.foundation.support.vo.BankdocDetailVO;
import com.ejianc.foundation.support.vo.BankdocVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bankdocDetail"})
public class BankdocDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBankdocDetailService bankdocDetailService;
    @Autowired
    private IBankdocService bankdocService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BankdocDetailVO> saveOrUpdate(@RequestBody BankdocDetailVO saveorUpdateVO) {
        BankdocDetailEntity entity = (BankdocDetailEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), BankdocDetailEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.bankdocDetailService.saveOrUpdate((Object)entity, false);
        BankdocDetailVO vo = (BankdocDetailVO)((Object)BeanMapper.map((Object)((Object)entity), BankdocDetailVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankdocDetailVO> queryDetail(Long id) {
        BankdocDetailEntity entity = (BankdocDetailEntity)((Object)this.bankdocDetailService.selectById(id));
        BankdocDetailVO vo = (BankdocDetailVO)((Object)BeanMapper.map((Object)((Object)entity), BankdocDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<BankdocDetailVO> bankdocDetails = this.bankdocDetailService.queryListByPid(id);
        if (bankdocDetails != null && bankdocDetails.size() > 0) {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237[xxxx]\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.bankdocDetailService.delete(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List dataList = this.bankdocDetailService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @GetMapping(value={"/detailListByBankdocCode"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryDetailListByBankdocCode(@RequestParam String bankdocTypeCode, @RequestParam(value="condition", required=false) String condition) {
        JSONObject jsonParam;
        BankdocVO bankdocVo = this.bankdocService.queryUniqueByCode(bankdocTypeCode);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isNotBlank((String)condition) && !"null".equals(condition) && null != (jsonParam = JSONObject.parseObject((String)condition)).get((Object)"tenantId")) {
            tenantId = Long.valueOf(jsonParam.get((Object)"tenantId").toString());
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("bankdocId", new Parameter("eq", (Object)bankdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List dataList = this.bankdocDetailService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        return CommonResponse.success((Object)ResultAsTree.createTreeData((List)resultMapList));
    }

    @RequestMapping(value={"/enabled/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody BankdocDetailVO bankdocDetailVo) {
        this.bankdocDetailService.updateEnabled(bankdocDetailVo);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.bankdocDetailService.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BankdocDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"customer-import.xlsx", (String)"\u5ba2\u6237\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/refBankdocDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BankdocDetailVO>> refBankdocDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.bankdocDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankdocDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

