package com.ejianc.foundation.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.DefdocEntity;
import com.ejianc.foundation.support.vo.BankdocVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.BankdocMapper;
import com.ejianc.foundation.support.bean.BankdocEntity;
import com.ejianc.foundation.support.service.IBankdocService;

import java.util.List;

/**
 * 银行档案类别实体
 * 
 * @author generator
 * 
 */
@Service("bankdocService")
public class BankdocServiceImpl extends BaseServiceImpl<BankdocMapper, BankdocEntity> implements IBankdocService{

    @Override
    public List<BankdocVO> queryByCode(String bankdocCode) {
        QueryWrapper<BankdocEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("code", bankdocCode);
        List<BankdocEntity> entities = baseMapper.selectList(wrapper);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, BankdocVO.class);
        }
        return null;
    }

    @Override
    public BankdocVO queryDetail(Long id) {
        BankdocEntity entity = baseMapper.selectById(id);
            if (entity != null) {
                return BeanMapper.map(entity, BankdocVO.class); }
            return null;
        }


    @Override
    public void delete(List<Long> ids) {
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public BankdocVO queryUniqueByCode(String bankdocTypeCode) {
        QueryWrapper<BankdocEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("code", bankdocTypeCode);
        List<BankdocEntity> entities = baseMapper.selectList(wrapper);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.map(entities.get(0), BankdocVO.class);
        }
        return null;
    }
}
