package com.ejianc.foundation.support.service.impl;

import com.ejianc.foundation.support.vo.BankdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.BankdocDetailMapper;
import com.ejianc.foundation.support.bean.BankdocDetailEntity;
import com.ejianc.foundation.support.service.IBankdocDetailService;

import java.util.List;

/**
 * 银行档案实体
 * 
 * @author generator
 * 
 */
@Service("bankdocDetailService")
public class BankdocDetailServiceImpl extends BaseServiceImpl<BankdocDetailMapper, BankdocDetailEntity> implements IBankdocDetailService{
    @Autowired
    private BankdocDetailMapper bankdocDetailMapper;
    @Override
    public List<BankdocDetailVO> queryListByBankdocId(List<Long> ids) {
        StringBuffer buffer = new StringBuffer();
        if (ids.size() > 0) {
            for (int i = 0; i < ids.size(); i++) {
                buffer.append(ids.get(i));
                if (i < (ids.size() - 1)) {
                    buffer.append(",");
                }
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BankdocDetailEntity> entity = bankdocDetailMapper.queryListByBankdocId(buffer.toString(), tenantId);
        if (entity != null) {
            return BeanMapper.mapList(entity, BankdocDetailVO.class);
        }
        return null;
    }


    @Override
    public BankdocDetailVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BankdocDetailEntity entity = bankdocDetailMapper.queryDetail(id,tenantId);
        if(entity != null) {
            return BeanMapper.map(entity, BankdocDetailVO.class);
        }

        return null;
    }


    @Override
    public List<BankdocDetailVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BankdocDetailEntity> entityList = bankdocDetailMapper.queryListByPid(id,tenantId);
        if (entityList != null) {
            return BeanMapper.mapList(entityList, BankdocDetailVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        bankdocDetailMapper.deleteBean(id,tenantId);
    }

    @Override
    public void updateEnabled(BankdocDetailVO bankdocDetailVo) {
        BankdocDetailVO condition = queryDetail(bankdocDetailVo.getId());
        bankdocDetailMapper.updateEnabled(bankdocDetailVo.getEnabled(), condition.getTenantId());
    }


}
