/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.service.engine;

import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeReternVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.PreCodeVO;
import com.ejianc.foundation.billcode.entity.BillCodeSNEntity;
import com.ejianc.foundation.billcode.entity.PreCodeEntity;
import com.ejianc.foundation.billcode.service.IBcrSnService;
import com.ejianc.foundation.billcode.service.IBillCodeReturnService;
import com.ejianc.foundation.billcode.service.IPreCodeService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billCodeEngineService")
public class BillCodeEngineServiceImp
implements IBillCodeEngineService {
    @Autowired
    private IBcrSnService bcrSnService;
    @Autowired
    private IPreCodeService preCodeService;
    @Autowired
    private IBillCodeReturnService billCodeReturnService;

    @Override
    public BillCodeSNVO querySNVO(String ruleId, String markStr, Long tenantId) {
        BillCodeSNVO resp = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter("eq", (Object)ruleId));
        queryParam.getParams().put("mark_str", new Parameter("eq", (Object)markStr));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        List eList = this.bcrSnService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = (BillCodeSNVO)((Object)BeanMapper.map(eList.get(0), BillCodeSNVO.class));
        }
        return resp;
    }

    @Override
    public void insertSNVO(BillCodeSNVO billCodeSNVO) {
        this.bcrSnService.saveOrUpdate(BeanMapper.map((Object)((Object)billCodeSNVO), BillCodeSNEntity.class), false);
    }

    @Override
    public void updateSNVO(String ruleId, String markStr, String lastsn, Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter("eq", (Object)ruleId));
        queryParam.getParams().put("mark_str", new Parameter("eq", (Object)markStr));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        List eList = this.bcrSnService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            BillCodeSNEntity updateEntity = (BillCodeSNEntity)((Object)eList.get(0));
            updateEntity.setLastsn(lastsn);
            this.bcrSnService.saveOrUpdate((Object)updateEntity, false);
        }
    }

    @Override
    public List<BillCodeReternVO> queryRtnVO(String ruleId, String markStr, Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter("eq", (Object)ruleId));
        queryParam.getParams().put("mark_str", new Parameter("eq", (Object)markStr));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        List eList = this.billCodeReturnService.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)eList, BillCodeReternVO.class);
    }

    @Override
    public void insertPreCode(PreCodeVO precode) {
        this.preCodeService.saveOrUpdate(BeanMapper.map((Object)((Object)precode), PreCodeEntity.class), false);
    }

    @Override
    public void deletRtnCodeBatch(List<BillCodeReternVO> delList) {
        List delIds = delList.stream().map(r -> r.getId()).collect(Collectors.toList());
        this.billCodeReturnService.removeByIds(delIds, false);
    }
}

