package com.ejianc.foundation.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.BankMapper;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;

import java.util.List;

/**
 * 银行档案实体
 * 
 * @author generator
 * 
 */
@Service("bankService")
public class BankServiceImpl extends BaseServiceImpl<BankMapper, BankEntity> implements IBankService{
    @Autowired
    private BankMapper bankMapper;


    @Override
    public List<BankVO> queryBankCategoryDetail(Long bankCategoryId) {
        List<BankVO> bankVOS = baseMapper.queryBankCategoryDetail(bankCategoryId);

        return bankVOS;
    }

    @Override
    public List<BankVO> detailRef(Long bankCategoryId) {
        QueryWrapper<BankEntity> wrapper=new QueryWrapper<>();
        wrapper.eq("bank_category_id",bankCategoryId);
        List<BankEntity>entities=baseMapper.selectList(wrapper);
        List<BankVO>detailVos= BeanMapper.mapList(entities,BankVO.class);
        return null;
    }
}
