package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.vo.BankCategoryVO;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.BankMapper;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 银行档案实体
 * 
 * @author generator
 * 
 */
@Service("bankService")
public class BankServiceImpl extends BaseServiceImpl<BankMapper, BankEntity> implements IBankService {
    @Autowired
    private BankMapper bankMapper;

    @Override
    public List<BankVO> queryBankCategoryDetail(Long bankCategoryId) {
        List<BankVO> bankVOS = baseMapper.queryBankCategoryDetail(bankCategoryId);

        return bankVOS;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
            Long tenantId = InvocationInfoProxy.getTenantid();
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
            Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
            boolean isFailed = false;
            MultipartFile mf = null;
            for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
                mf = entity.getValue();
                String originalFileName = mf.getOriginalFilename();
                String extName = null;
                originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFileName.replaceAll("00.", "");
                extName = FileUtils.getFileExt(originalFileName, false);
                if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                    isFailed = true;
                    break;
                }
            }
            JSONObject resp = new JSONObject();

            if (isFailed) {
                return CommonResponse.error("文件格式不合法！");
            }
            return null;
        }


    @Override
    public void updateEnabled(BankVO bankVo) {
        BankEntity bankEntity = this.selectById(bankVo.getId());
        bankEntity.setEnabled(bankVo.getEnabled());
        saveOrUpdate(bankEntity);
    }


}