/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller.api;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/billCodeApi/"})
public class BillCodeApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeGenerator generator;

    @GetMapping(value={"getByCode"})
    public CommonResponse<String> getCodeBatchByRuleCode(@RequestParam(value="code") String code, @RequestParam(value="tenantId") Long tenantId) throws BillCodeException {
        try {
            String billCode = this.generator.generateBillCodeById(code, tenantId);
            return CommonResponse.success((String)"\u83b7\u53d6\u7f16\u7801\u6210\u529f\uff01", (Object)billCode);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u7f16\u7801\u83b7\u53d6\u5931\u8d25\uff01");
        }
    }

    @GetMapping(value={"getCodeBatchByCode"})
    public CommonResponse<List<String>> getCodeBatchByRuleCode(@RequestParam(value="code") String code, @RequestParam(value="tenantId") Long tenantId, @RequestParam(value="count") int count) {
        try {
            List<String> codeList = this.generator.generateBillCodeById(code, tenantId, count);
            return CommonResponse.success((String)"\u83b7\u53d6\u7f16\u7801\u6210\u529f\uff01", codeList);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u7f16\u7801\u83b7\u53d6\u5931\u8d25\uff01");
        }
    }
}

