/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankMapper;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="bankService")
public class BankServiceImpl
extends BaseServiceImpl<BankMapper, BankEntity>
implements IBankService {
    @Autowired
    private BankMapper bankMapper;

    @Override
    public List<BankVO> queryBankCategoryDetail(Long bankCategoryId) {
        List<BankVO> bankVOS = ((BankMapper)this.baseMapper).queryBankCategoryDetail(bankCategoryId);
        return bankVOS;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        return null;
    }

    @Override
    public void updateEnabled(BankVO bankVo) {
        BankEntity bankEntity = (BankEntity)((Object)this.selectById(bankVo.getId()));
        bankEntity.setEnabled(bankVo.getEnabled());
        this.saveOrUpdate((Object)bankEntity);
    }
}

