package com.ejianc.foundation.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.BankCategoryMapper;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.service.IBankCategoryService;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 银行类别实体
 * 
 * @author generator
 * 
 */
@Service("bankCategoryService")
public class BankCategoryServiceImpl extends BaseServiceImpl<BankCategoryMapper, BankCategoryEntity> implements IBankCategoryService{
   @Autowired
   private IBankService bankService;

    @Override
    public CommonResponse delete(@RequestBody List<Long> ids) {
        LambdaQueryWrapper<BankEntity> lambda = Wrappers.<BankEntity>lambdaQuery();
        lambda.in (BankEntity::getBankCategoryId, ids);
        lambda.eq(BankEntity::getDr, 0);
        lambda.eq(BankEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<BankEntity> entities = bankService.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)) {
            return CommonResponse.error("删除失败！该银行类别已存在银行档案信息，不允许删除");
        }else {
            super.removeByIds(ids,false);
            return CommonResponse.success("删除成功");
        }
    }
}
