package com.ejianc.foundation.support.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdRelationApi;
import com.ejianc.foundation.metadata.vo.MdQuoteVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.mapper.BillTypeMapper;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;

@SuppressWarnings({ "unchecked", "rawtypes" })
@Service
public class BillTypeServiceImpl extends BaseServiceImpl<BillTypeMapper, BillTypeEntity> implements IBillTypeService {

	@Value("${common.env.base-host}")
	private String baseHost;

	@Value("${oms.tenantid}")
	private Long baseTenantId;

	private Gson gson = new Gson();

	@Autowired
	private IModuleService moduleService;

	@Autowired
	private IMdRelationApi mdRelationApi;

	@Override
	public void delete(List<Long> ids) {
		baseMapper.deleteBatchIds(ids);
	}

	@Override
	public BillTypeVO queryDetail(Long id) {
		BillTypeEntity entity = baseMapper.selectById(id);
		if(entity != null) {
			return BeanMapper.map(entity, BillTypeVO.class);
		}
		return null;
	}
	
	@Override
	public List<Map<String, Object>> getBillTypeTree() {
		
		QueryParam queryParam = new QueryParam();
		LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
    	orderMap.put("sequence", "asc");
    	queryParam.setOrderMap(orderMap);
		List<ModuleEntity> moduleList = moduleService.queryList(queryParam, false);
				
		QueryWrapper<BillTypeEntity> query = new QueryWrapper<>();
		query.eq("dr", BaseVO.DR_UNDELETE);
		query.eq("tenant_id", baseTenantId);
		List<BillTypeEntity> list = baseMapper.selectList(query);

		List<Map> resultMapList = new ArrayList<Map>();
    	Map map = null;
    	for(ModuleEntity entity:moduleList) {
    		map = new HashMap<>();
    		map.put("id", entity.getId());
    		map.put("key", entity.getId());
    		map.put("name", entity.getModuleName());
    		map.put("title", entity.getModuleName());
    		map.put("parentId", entity.getParentId());
    		map.put("nodeType", entity.getNodeType());
    		map.put("code", entity.getModuleCode());
    		resultMapList.add(map);
    	}

		if(list != null && list.size() > 0) {
			for(BillTypeEntity entity:list) {
				map = new HashMap<>();
				map.put("id", entity.getId());
				map.put("key", entity.getId());
				map.put("name", entity.getBillName());
				map.put("title", entity.getBillName());
				map.put("parentId", entity.getModuleId());
				map.put("nodeType", "billType");
				map.put("code", entity.getBillCode());
				map.put("metadataId", entity.getMetadataId());
				resultMapList.add(map);
			}
		}

		return ResultAsTree.createTreeData(resultMapList);
	}

	/**
	 * @param billTypeCode
	 * @param billId
	 * @Author mrsir_wxp
	 * @Date 2020/7/14 单据编码引用校验
	 * @Description checkQuote
	 * @Param [billTypeCode, billId]
	 * @Return void
	 */
	@Override
	public CommonResponse<String> checkQuote(String billTypeCode, Long billId) {
		try {
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("billCode", new Parameter("eq",billTypeCode));
			IPage<BillTypeEntity> pageData = super.queryPage(queryParam, false);
			if(pageData.getTotal()>0){
				BillTypeVO billTypeVo = BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
				//2、根据元数据获取引用关系信息
				CommonResponse<List<MdQuoteVO>> quoteResponse = mdRelationApi.queryQuoteById(billTypeVo.getMetadataId());
				if(quoteResponse.isSuccess()){
					List<MdQuoteVO> quoteVOs = quoteResponse.getData();
					if(quoteVOs!=null&&quoteVOs.size()>0){
						for(MdQuoteVO vo : quoteVOs){
							Map<String, String> paramterMap = new HashMap<>();
							paramterMap.put("billId", String.valueOf(billId));
							paramterMap.put("tableName", vo.getTableName());
							paramterMap.put("column", vo.getAttributeCode());
							String url = baseHost + vo.getProjectName() + "/commonstate/queryQuoteById";
							String paramterStr = gson.toJson(paramterMap);
							try {
								String result = ReferHttpClientUtils.postByJson(url, paramterStr);
								CommonResponse<String> data = gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
								if(data.isSuccess()){
									if("0".equals(data.getData())){
										continue;
									}else{
										String msg = "该单据已被下游单据（"+vo.getEntityDisplayName()+"）引用";
										throw new BusinessException(msg);
									}
								}else{
									throw new BusinessException("查询引用信息失败");
								}
							} catch (Exception e) {
								throw new BusinessException(e.getMessage());
							}
						}
					}
				}else{
					throw new BusinessException("根据元数据id："+billTypeVo.getMetadataId()+"查询引用信息失败！");
				}
			}else {
				throw new BusinessException("根据单据类型编码查询单据类型信息失败！");
			}
		}catch (Exception e){
			return CommonResponse.error(e.getMessage());
		}
		return CommonResponse.success();
	}
}
