package com.ejianc.foundation.support.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.mapper.DefdocDetailMapper;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@Service
public class DefdocDetailServiceImpl implements IDefdocDetailService {

	@Autowired
	private DefdocDetailMapper defdocDetailMapper;

	@Value("${oms.tenantid}")
	private String OMS_TENANT;

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4 判断操作租户是否是平台运营租户
	 * @Description isOmsTenant
	 * @Param []
	 * @Return boolean true 平台运营租户，false 其他租户
	 */
	private boolean isOmsTenant(){
		Long tenantId = InvocationInfoProxy.getTenantid();
		return OMS_TENANT.equals(tenantId.toString());
	}
	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4 判断某个租户某个自定义档案是否有自定义值
	 * @Description hasData
	 * @Param [defId, tenantId]
	 * @Return boolean
	 */
	private boolean hasData(Long defId,Long tenantId){
		Map<String, Object> condition = new HashMap<>();
		condition.put("tenantId", tenantId);
		condition.put("defdocId", defId);
		List<DefdocDetailEntity> resultList = defdocDetailMapper.queryList(condition);
		return !ListUtil.isEmpty(resultList);
	}
	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4 根据自定义档案id,查询所有自定义档案项
	 * @Description queryListByDefdocId
	 * @Param [ids]
	 * @Return java.util.List<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@Override
	public List<DefdocDetailVO> queryListByDefdocId(List<Long> ids) {
		StringBuffer buffer = new StringBuffer();
		if (ids.size() > 0) {
			for (int i = 0; i < ids.size(); i++) {
				buffer.append(ids.get(i));
				if (i < (ids.size() - 1)) {
					buffer.append(",");
				}
			}
		}
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<DefdocDetailEntity> entity = defdocDetailMapper.queryListByDefdocId(buffer.toString(), tenantId);
		if (entity != null) {
			return BeanMapper.mapList(entity, DefdocDetailVO.class);
		}

		return null;
	}

	/**
	 * 根据 自定义档案id 查询自定义档案项
	 *
	 * @param defId
	 * @return
	 */
	@Override
	public List<DefdocDetailVO> getDefDocByDefId(Long defId) {
		List<DefdocDetailEntity> list = defdocDetailMapper.getDefDocByDefId(defId,InvocationInfoProxy.getTenantid());
		if (list != null) {
			return BeanMapper.mapList(list, DefdocDetailVO.class);
		}

		return null;
	}

	@Override
	public DefdocDetailVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		DefdocDetailEntity entity = defdocDetailMapper.queryDetail(id,tenantId);
		if(entity != null) {
			return BeanMapper.map(entity, DefdocDetailVO.class);
		}
		return null;
	}
	@Override
	public DefdocDetailVO queryDetailOMS_TENANT(Long id) {
		DefdocDetailEntity entity = defdocDetailMapper.queryDetail(id,Long.parseLong(OMS_TENANT));
		if(entity != null) {
			return BeanMapper.map(entity, DefdocDetailVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		defdocDetailMapper.deleteBean(id,tenantId);
	}

	@Override
	public List<DefdocDetailVO> queryListByPid(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<DefdocDetailEntity> entityList = defdocDetailMapper.queryListByPid(id,tenantId);
		if (entityList != null) {
			return BeanMapper.mapList(entityList, DefdocDetailVO.class);
		}
		return null;
	}

	@Override
	public void updateEnabled(DefdocDetailVO defdocDetailVo) {
		DefdocDetailVO condition = queryDetail(defdocDetailVo.getId());
		defdocDetailMapper.updateEnabled(defdocDetailVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
	}

	@Override
	public DefdocDetailVO queryDetailByName(String name) {
		Map<String, Object> condition = new HashMap<>();
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		condition.put("name", name);
		List<DefdocDetailEntity> entities = defdocDetailMapper.queryList(condition);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), DefdocDetailVO.class);
		}
		return null;
	}

	/**
	 * 根据自定义档案名称查询自定义档案
	 *
	 * @param defDocId
	 * @param name
	 * @return
	 */
	@Override
	public DefdocDetailVO getDefDocByName(Long defDocId, String name) {
		Map<String, Object> condition = new HashMap<>();
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		condition.put("defDocId", defDocId);
		condition.put("name", name);
		List<DefdocDetailEntity> entities = defdocDetailMapper.getDefDocByName(condition);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), DefdocDetailVO.class);
		}
		return null;
	}

	@Override
	public List<DefdocDetailEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<DefdocDetailEntity> resultList = defdocDetailMapper.queryList(condition);
		return resultList;
	}

	@Override
	public void saveDetail(DefdocDetailEntity entity) {
		defdocDetailMapper.saveDetail(entity);
	}

	@Override
	public void updateDetail(DefdocDetailEntity entity) {
		defdocDetailMapper.updateDetail(entity);
	}

	@Override
	public void insertDetailsFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		defdocDetailMapper.insertDetailsFromPlatform(tenantId);
	}

}
