/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.engine;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeInfo;
import com.ejianc.foundation.billcode.engine.BillcodeSNReferProducer;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeReternVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.PreCodeVO;
import com.ejianc.framework.cache.redis.CacheManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillCodeEngine {
    private static final Logger logger = LoggerFactory.getLogger(BillCodeEngine.class);
    private final String BILL_CODE_SN_REFER_CACHE_KEY_PREFIX = "ejcbillcode";
    private final String RETURN_BILL_CODE_CACHE_KEY_PREFIX = "returnejcbillcode";
    private final String CACHE_KEY_SEPERATOR = ":";
    private BillCodeInfo info;
    private IBillCodeEngineService billCodeEngineService;
    private String lastsn;
    private CacheManager cacheManager;
    private BillcodeSNReferProducer billcodeSNReferProducer;

    public BillCodeEngine(BillCodeInfo billCodeInfo, IBillCodeEngineService persisServ, CacheManager cacheManager, BillcodeSNReferProducer billcodeSNReferProducer) {
        this.info = billCodeInfo;
        this.billCodeEngineService = persisServ;
        this.billcodeSNReferProducer = billcodeSNReferProducer;
        this.cacheManager = cacheManager;
    }

    public String getLastsn() {
        return this.lastsn;
    }

    public void setLastsn(String lastsn) {
        this.lastsn = lastsn;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public BillcodeSNReferProducer getBillcodeSNReferProducer() {
        return this.billcodeSNReferProducer;
    }

    public void setBillcodeSNReferProducer(BillcodeSNReferProducer billcodeSNReferProducer) {
        this.billcodeSNReferProducer = billcodeSNReferProducer;
    }

    public void insertInitSN(Long tenantId) throws BillCodeException {
        BillCodeSNVO initvo = new BillCodeSNVO();
        initvo.setLastsn("0");
        initvo.setMarkStr(this.info.getBillCodeSNRefer());
        initvo.setMarkStrDesc(this.info.getBillCodeSNReferDesc());
        initvo.setRuleId(this.info.getPk_bilcodebase());
        initvo.setTenantId(tenantId);
        try {
            this.billCodeEngineService.insertSNVO(initvo);
        }
        catch (Exception arg2) {
            logger.error("\u65b0\u589e\u521d\u59cb\u5316SN\u5f02\u5e38\uff0c", (Throwable)arg2);
            throw new BillCodeException(arg2.getMessage());
        }
    }

    public IBillCodeEngineService getBillCodeEngineService() {
        return this.billCodeEngineService;
    }

    public void setBillCodeEngineService(IBillCodeEngineService billCodeEngineService) {
        this.billCodeEngineService = billCodeEngineService;
    }

    public BillCodeInfo getInfo() {
        return this.info;
    }

    public void setInfo(BillCodeInfo info) {
        this.info = info;
    }

    public String[] getBillCode(int num, Long tenantId) throws BillCodeException {
        BillCodeSNVO billcodesnVO = this.setLastSN(tenantId);
        ArrayList<String> billcodes = new ArrayList<String>();
        if (this.info.isautofill()) {
            this.getReturnedBillCode(num, billcodes, tenantId);
        }
        if ((num -= billcodes.size()) > 0) {
            this.getSequenceBillCode(num, billcodes);
        }
        billcodesnVO.setLastsn(this.lastsn);
        this.cacheManager.set(this.getBillcodeSnReferCacheKey(this.info.getPk_bilcodebase(), this.info.getBillCodeSNRefer(), tenantId), (Serializable)((Object)billcodesnVO));
        this.billcodeSNReferProducer.sendQueue(billcodesnVO);
        return billcodes.toArray(new String[0]);
    }

    private void getSequenceBillCode(int num, List<String> billcodes) throws BillCodeException {
        if (this.info.getSerialNumInfo().getSnGenerator().isRunOutSNumber(this.lastsn, num, this.info.getSerialNumInfo().getSnLength()).booleanValue()) {
            throw new BillCodeException("\u6ca1\u6709\u591a\u4f59\u7684\u5355\u636e\u53f7\u53ef\u4f9b\u5206\u914d");
        }
        String codenosn = this.info.getBillCodeTemplte();
        for (int i = 0; i < num; ++i) {
            this.getNextSNumber();
            String billcode = codenosn.replaceFirst("##SN##", this.lastsn);
            billcodes.add(billcode);
        }
    }

    private void getNextSNumber() {
        this.lastsn = this.info.getSerialNumInfo().getSnGenerator().getNextSNumber(this.lastsn, this.info.getSerialNumInfo().isAppendZero(), this.info.getSerialNumInfo().getSnLength());
    }

    private void getReturnedBillCode(int num, List<String> billcodes, Long tenantId) throws BillCodeException {
        List<BillCodeReternVO> rtnvos = null;
        String rtnvosJsonStr = (String)((Object)this.cacheManager.get(this.getReturnBillcodeSnReferCacheKey(this.info.getPk_bilcodebase(), this.info.getBillCodeSNRefer(), tenantId)));
        if (StringUtils.isNotBlank((CharSequence)rtnvosJsonStr)) {
            rtnvos = JSONArray.parseArray((String)rtnvosJsonStr, BillCodeReternVO.class);
        }
        if (rtnvos == null) {
            rtnvos = this.billCodeEngineService.queryRtnVO(this.info.getPk_bilcodebase(), this.info.getBillCodeSNRefer(), tenantId);
            this.cacheManager.set(this.getReturnBillcodeSnReferCacheKey(this.info.getPk_bilcodebase(), this.info.getBillCodeSNRefer(), tenantId), (Serializable)((Object)JSONArray.toJSONString(rtnvos)));
        }
        ArrayList<BillCodeReternVO> alReturn = new ArrayList<BillCodeReternVO>();
        String codenosn = this.info.getBillCodeTemplte();
        int sucNum = 0;
        if (CollectionUtils.isNotEmpty(alReturn)) {
            for (BillCodeReternVO bcr : alReturn) {
                String billcode = codenosn.replaceFirst("##SN##", bcr.getRtnsn());
                alReturn.add(bcr);
                billcodes.add(billcode);
                if (++sucNum < num) continue;
                break;
            }
        }
        try {
            if (alReturn.size() > 0) {
                List rtnsns = alReturn.stream().map(BillCodeReternVO::getRtnsn).collect(Collectors.toList());
                rtnvos = rtnvos.stream().filter(r -> !rtnsns.contains(r.getRtnsn())).collect(Collectors.toList());
                this.cacheManager.set(this.getReturnBillcodeSnReferCacheKey(this.info.getPk_bilcodebase(), this.info.getBillCodeSNRefer(), tenantId), (Serializable)((Object)JSONArray.toJSONString(rtnvos)));
                ArrayList<BillCodeReternVO> delList = new ArrayList<BillCodeReternVO>();
                delList.add((BillCodeReternVO)((Object)alReturn.get(0)));
                this.billCodeEngineService.deletRtnCodeBatch(delList);
            }
        }
        catch (Exception arg9) {
            logger.error("\u5f02\u5e38: ", (Throwable)arg9);
            throw new BillCodeException(arg9.getMessage());
        }
    }

    private String getReturnBillcodeSnReferCacheKey(String pk_bilcodebase, String billCodeSNRefer, Long tenantId) {
        return "returnejcbillcode:" + pk_bilcodebase + billCodeSNRefer + tenantId;
    }

    private BillCodeSNVO setLastSN(Long tenantId) throws BillCodeException {
        BillCodeSNVO billcodesnVO = (BillCodeSNVO)((Object)this.cacheManager.get(this.getBillcodeSnReferCacheKey(this.info.getPk_bilcodebase(), this.info.getBillCodeSNRefer(), tenantId)));
        if (billcodesnVO == null) {
            billcodesnVO = this.billCodeEngineService.querySNVO(this.info.getPk_bilcodebase(), this.info.getBillCodeSNRefer(), tenantId);
        }
        if (billcodesnVO == null) {
            billcodesnVO = new BillCodeSNVO();
            billcodesnVO.setRuleId(this.info.getPk_bilcodebase());
            billcodesnVO.setMarkStr(this.info.getBillCodeSNRefer());
            billcodesnVO.setLastsn("0");
            billcodesnVO.setMarkStrDesc(this.info.getBillCodeSNReferDesc());
            billcodesnVO.setTenantId(tenantId);
            this.lastsn = "0";
        } else {
            Boolean isEffectiveSN = this.info.getSerialNumInfo().getSnGenerator().isEffectiveSNumber(billcodesnVO.getLastsn());
            if (!isEffectiveSN.booleanValue()) {
                throw new BillCodeException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u4fee\u6539\u4e86\u7f16\u7801\u89c4\u5219\u7684\u6d41\u6c34\u53f7\u751f\u6210\u5668\uff0c\u672a\u91cd\u7f6e\u6d41\u6c34\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002");
            }
            this.lastsn = this.info.getSerialNumInfo().getSnGenerator().getFormatedSNumber(billcodesnVO.getLastsn(), this.info.getSerialNumInfo().isAppendZero(), this.info.getSerialNumInfo().getSnLength());
        }
        return billcodesnVO;
    }

    private String getBillcodeSnReferCacheKey(String pk_bilcodebase, String billCodeSNRefer, Long tenantId) {
        return "ejcbillcode:" + pk_bilcodebase + billCodeSNRefer + tenantId;
    }

    public void insertPrecode(String billCode, Long tenantId) {
        if (this.info.isautofill()) {
            String sn = this.getSNByBillCode(billCode);
            if (sn == null || sn.isEmpty()) {
                return;
            }
            PreCodeVO precode = new PreCodeVO();
            precode.setPkRulebase(this.info.getPk_bilcodebase());
            precode.setMarkStr(this.info.getBillCodeSNRefer());
            precode.setMarkStrDesc(this.info.getBillCodeSNReferDesc());
            precode.setLastsn(sn);
            precode.setTenantId(tenantId);
            precode.setBillcode(billCode);
            this.billCodeEngineService.insertPreCode(precode);
        }
    }

    private String getSNByBillCode(String billCode) {
        if (billCode != null && billCode.length() != 0) {
            if (billCode.trim().length() != this.info.getBillcodeLength()) {
                return null;
            }
            int i = this.info.getBillCodeTemplte().indexOf("##SN##");
            if (i == -1) {
                return null;
            }
            int j = i + this.info.getSerialNumInfo().getSnLength();
            String sn = billCode.substring(i, j);
            return this.info.getSerialNumInfo().getSnGenerator().isEffectiveSNumber(sn) == false ? null : sn;
        }
        return null;
    }
}

