/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.elemproc.impl;

import com.ejianc.foundation.billcode.BillCodeEngineContext;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.billcode.util.BillCodeProcessUtils;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import java.util.Date;

public class SysTimeElemProcessor
implements IElemProcessor {
    @Override
    public int getCanProcElemType() {
        return 2;
    }

    @Override
    public BillCodeElemInfo procElemInfo(BillCodeRuleAttrVO elemvo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        Date sysdate = BillCodeEngineContext.getInstance().getSysDateImp().getDate();
        String elemSNRefer = BillCodeProcessUtils.getDateElemSNRefer(Integer.valueOf(elemvo.getElemIsRefer()), sysdate);
        String elemSNReferDesc = "";
        if (!elemSNRefer.equals("")) {
            elemSNRefer = "^sysdate^" + elemSNRefer;
            elemSNReferDesc = "#date#" + elemSNRefer.length() + "|";
        }
        String elemProcedValue = BillCodeProcessUtils.formatDate(sysdate, elemvo.getDateElemDisplayFormat());
        BillCodeElemInfo eleminfo = new BillCodeElemInfo();
        eleminfo.setElemSNRefer(elemSNRefer);
        eleminfo.setElemSNReferDesc(elemSNReferDesc);
        eleminfo.setElemValue(elemProcedValue.trim().substring(0, elemvo.getElemLength()));
        eleminfo.setElemLength(elemvo.getElemLength());
        eleminfo.setSysTimeElem(true);
        return eleminfo;
    }
}

