package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 客户
 * 
 * @author guoming
 *
 */
@TableName("ejc_support_customer")
public class CustomerEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "code")
	private String code; // 客户编码

	@TableField(value = "name")
	private String name; // 客户名称

	@TableField(value = "category_id")
	private Long categoryId; // 客户分类ID

	@TableField(exist = false)
	private String categoryName;

	@TableField(value = "social_credit_code")
	private String socialCreditCode; // 社会信用代码

	@TableField(value = "legal")
	private String legal; // 法定代表人

	@TableField(value = "tax_payer_type")
	private Long taxPayerType; // 纳税人类型

	@TableField(value = "customer_type")
	private Long customerType; // 客户类型

	@TableField(value = "area")
	private String area; // 地区

	@TableField(value = "address")
	private String address; // 详细地址

	@TableField(value = "telephone")
	private String telephone; // 客户电话

	@TableField(value = "bank_name")
	private String bankName; // 账户名

	@TableField(value = "bank_account")
	private String bankAccount;// 银行账号

	@TableField(value = "bank_code")
	private String bankCode; // 开户行

	@TableField(value = "description")
	private String description; // 描述

	@TableField(value = "org_id")
	private Long orgId; // 所属组织ID

	@TableField(value = "inside_org_id")
	private Long insideOrgId; // 内部客商--来源组织id(青岛市政）

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getLegal() {
		return legal;
	}

	public void setLegal(String legal) {
		this.legal = legal;
	}

	public Long getTaxPayerType() {
		return taxPayerType;
	}

	public void setTaxPayerType(Long taxPayerType) {
		this.taxPayerType = taxPayerType;
	}

	public Long getCustomerType() {
		return customerType;
	}

	public void setCustomerType(Long customerType) {
		this.customerType = customerType;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getInsideOrgId() {
		return insideOrgId;
	}

	public void setInsideOrgId(Long insideOrgId) {
		this.insideOrgId = insideOrgId;
	}

}
