package com.ejianc.foundation.share.controller.api;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.util.JdbcOracle;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/sync/")
public class SyncShareApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    
    @GetMapping("initSdbjSupplier")
    public CommonResponse<String> initSdbjSupplier() {
		String sql = "select  * from FIWLDW ORDER BY LASTMODIFIEDTIME asc";
		List<SupplierEntity> supplierList = new ArrayList<>();
		supplierList = JdbcOracle.getSdbjSupplier(sql, "1247777316689256450");
		supplierService.saveOrUpdateBatch(supplierList, supplierList.size(), false);
    	return CommonResponse.success("初始化供方信息成功！");
    }

    @PostMapping("syncSupplierList")
    public CommonResponse<String> syncSupplierList(@RequestBody List<SupplierVO> supplierList) {
    	logger.info("同步供方档案开始----------");
    	if(supplierList!=null&&supplierList.size()>0){
    		//获取供方分类，若不存在则手动插入一条
    		Long categoryId = null;
    		String categoryName = null;
    		QueryWrapper<SupplierCategoryEntity> queryCategoryWrapper = new QueryWrapper<>();
    		queryCategoryWrapper.eq("code", "root");
    		queryCategoryWrapper.eq("dr", 0);
    		SupplierCategoryEntity supplierCategoryEntity = supplierCategoryService.getOne(queryCategoryWrapper);
    		if(supplierCategoryEntity!=null){
    			categoryId = supplierCategoryEntity.getId();
    			categoryName = supplierCategoryEntity.getName();
    		}else{
    			//新增一条供方分类
    			supplierCategoryEntity = new SupplierCategoryEntity();
    			supplierCategoryEntity.setId(IdWorker.getId());
    			supplierCategoryEntity.setName("供方分类");
    			supplierCategoryEntity.setCode("root");
    			supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
    			supplierCategoryService.saveOrUpdate(supplierCategoryEntity, false);
    			categoryId = supplierCategoryEntity.getId();
    			categoryName = supplierCategoryEntity.getName();
    		}
    		List<SupplierEntity> saveList = new ArrayList<>();
    		for(SupplierVO vo : supplierList){
    			//1、校验数据是否已存在，存在则执行修改方法，否则执行新增方法
    			QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
    			queryWrapper.eq("dr", 0);
    			queryWrapper.eq("source_id", vo.getSourceId());
    			SupplierEntity supplierEntity = supplierService.getOne(queryWrapper);
    			if(supplierEntity!=null){
    				//执行修改方法
    				supplierEntity.setCode(supplierEntity.getCode());
    				supplierEntity.setName(supplierEntity.getName());
    				supplierEntity.setSocialCreditCode(supplierEntity.getSocialCreditCode());
    				supplierEntity.setEnabled(supplierEntity.getEnabled());
    				saveList.add(supplierEntity);
    			}else{
    				//执行新增方法
    				vo.setCategoryId(categoryId);
    				vo.setCategoryName(categoryName);
    				saveList.add(BeanMapper.map(vo, SupplierEntity.class));
    			}
    		}
    		supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
    	}
    	logger.info("同步供方档案完成------666----------");
    	return CommonResponse.success("同步成功！");
    }

}
