package com.ejianc.foundation.billcode;

import com.ejianc.foundation.billcode.engine.BillCodeEngine;
import com.ejianc.foundation.billcode.lock.IBillCodeEngineLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillCodeGeneratorNeedAddTransaction {

    private Logger logger = LoggerFactory.getLogger(BillCodeGeneratorNeedAddTransaction.class);


    public String[] getBillCode(BillCodeEngine engine, IBillCodeEngineLock lock, int num, boolean isInsertPrecode, Long tenantId) throws BillCodeException {
        if (lock.getEngineLockType() == 1) {
            this.lockEngineRelatedRow(engine, lock, tenantId);
        }

        String[] billCode = engine.getBillCode(num, tenantId);
        if (isInsertPrecode) {
            engine.insertPrecode(billCode[0], tenantId);
        }

        return billCode;
    }

    private void lockEngineRelatedRow(BillCodeEngine engine, IBillCodeEngineLock lock, Long tenantId) throws BillCodeException {
        try {
            boolean e = lock.lock(engine.getInfo().getPk_bilcodebase(), engine.getInfo().getBillCodeSNRefer(), tenantId);
            if (!e) {
                engine.insertInitSN(tenantId);
            }
        } catch (Exception arg3) {
            logger.error("初始化SN异常，",arg3);
            lock.lock(engine.getInfo().getPk_bilcodebase(), engine.getInfo().getBillCodeSNRefer(), tenantId);
        }
    }
}
