package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankAccountMapper;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 银行账户实体
 * 
 * @author generator
 * 
 */
@Service("bankAccountService")
public class BankAccountServiceImpl extends BaseServiceImpl<BankAccountMapper, BankAccountEntity> implements IBankAccountService{

    @Autowired
    private IBankService bankService;

    @Autowired
    private IBankCategoryService categoryService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if(result.size()>10000){
                    return CommonResponse.error("超过10000条，请分批上传！");
                }
                // 处理导入文件
                Map<String, Integer> indexMap = new HashMap<>();
                List<BankAccountVO> voList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BankAccountVO vo = new BankAccountVO();
                    String warnType = "";

                    String bankCode = datas.get(0);
                    vo.setBankCode(bankCode);
                    if (indexMap.containsKey(bankCode)) {//账号重复
                        return CommonResponse.error("第"+(i+2)+"行账号和第" + (indexMap.get(bankCode)+2) + "行重复");
                    }else{
                        indexMap.put(bankCode, i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 户名为空
                        vo.setBankAccount(null);
                        warnType = warnType + "[户名为空]";
                    }else{
                        vo.setBankAccount(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//开户银行为空
                        vo.setBankName(null);
                        warnType =  warnType + "[开户银行为空]";
                    } else {
                        vo.setBankName(datas.get(2));
                    }

                    if (StringUtils.isEmpty(datas.get(3))) {//银行类别为空
                        vo.setCategoryName(null);
                        warnType =  warnType + "[银行类别为空]";
                    } else {
                        vo.setCategoryName(datas.get(3));
                    }

                    vo.setMemo(datas.get(4));// 备注

                    if (StringUtils.isEmpty(datas.get(5))) {// 默认为空
                        vo.setSupplierDefaultFlag(null);
                        vo.setCustomerDefaultFlag(null);
                        warnType = warnType + "[默认为空]";
                    } else {
                        if ("是".equals(datas.get(5))) {
                            vo.setSupplierDefaultFlag(1);
                            vo.setCustomerDefaultFlag(1);
                        } else {
                            vo.setSupplierDefaultFlag(0);
                            vo.setCustomerDefaultFlag(0);
                        }
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    voList.add(vo);
                }

                // 根据数据库赋值校验
                this.validate(voList);

                // 处理成功列表和失败列表
                List<BankAccountVO> successList = new ArrayList<>();
                List<BankAccountVO> errorList = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(voList)){
                    voList.forEach(vo ->{
                        if(StringUtils.isEmpty(vo.getWarnType())){
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    /**
     * 根据数据库赋值校验
     * @param voList
     * @return
     */
    private void validate(List<BankAccountVO> voList) {
        // 查询数据库
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bankCode", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getBankCode).distinct().collect(Collectors.toList())));
        List<BankAccountEntity> dataList = super.queryList(queryParam);
        List<String> bankCodes = dataList.stream().map(BankAccountEntity::getBankCode).distinct().collect(Collectors.toList());

        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("bankName", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getBankName).distinct().collect(Collectors.toList())));
        List<BankEntity> bankList = bankService.queryList(queryParam2);
        Map<String, BankEntity> bankMap = bankList.stream().collect(Collectors.toMap(x->x.getName() + "-" + x.getBankCategoryName(), Function.identity(), (x1, x2) -> x1));

        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("bankCategoryName", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getCategoryName).distinct().collect(Collectors.toList())));
        List<BankCategoryEntity> categoryList = categoryService.queryList(queryParam3);
        Map<String, BankCategoryEntity> categoryMap = categoryList.stream().collect(Collectors.toMap(x->x.getName(), Function.identity(), (x1, x2) -> x1));

        // 处理成功列表和失败列表
        List<BankAccountVO> successList = new ArrayList<>();
        List<BankAccountVO> errorList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(voList)){
            voList.forEach(vo ->{
                // 校验账户是否存在
                if(bankCodes.contains(vo.getBankCode())){
                    vo.setWarnType(vo.getWarnType() + "账号已存在");
                }
                // 添加银行分类主键
                if(categoryMap.containsKey(vo.getCategoryName())){
                    vo.setCategoryId(categoryMap.get(vo.getCategoryName()).getId());
                }
                // 添加银行档案主键
                if(bankMap.containsKey(vo.getBankName() + "-" + vo.getCategoryName())){
                    vo.setBankId(bankMap.get(vo.getBankName() + "-" + vo.getCategoryName()).getId());
                }
            });
        }
    }
}
