/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankAccountMapper;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="bankAccountService")
public class BankAccountServiceImpl
extends BaseServiceImpl<BankAccountMapper, BankAccountEntity>
implements IBankAccountService {
    @Autowired
    private IBankService bankService;
    @Autowired
    private IBankCategoryService categoryService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BankAccountVO> voList = new ArrayList<BankAccountVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BankAccountVO vo2 = new BankAccountVO();
                String warnType = "";
                String bankCode = (String)datas.get(0);
                vo2.setBankCode(bankCode);
                if (indexMap.containsKey(bankCode)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u8d26\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(bankCode) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(bankCode, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo2.setBankAccount(null);
                    warnType = warnType + "[\u6237\u540d\u4e3a\u7a7a]";
                } else {
                    vo2.setBankAccount((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo2.setBankName(null);
                    warnType = warnType + "[\u5f00\u6237\u94f6\u884c\u4e3a\u7a7a]";
                } else {
                    vo2.setBankName((String)datas.get(2));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    vo2.setCategoryName(null);
                    warnType = warnType + "[\u94f6\u884c\u7c7b\u522b\u4e3a\u7a7a]";
                } else {
                    vo2.setCategoryName((String)datas.get(3));
                }
                vo2.setMemo((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo2.setSupplierDefaultFlag(null);
                    vo2.setCustomerDefaultFlag(null);
                    warnType = warnType + "[\u9ed8\u8ba4\u4e3a\u7a7a]";
                } else if ("\u662f".equals(datas.get(5))) {
                    vo2.setSupplierDefaultFlag(Integer.valueOf(1));
                    vo2.setCustomerDefaultFlag(Integer.valueOf(1));
                } else {
                    vo2.setSupplierDefaultFlag(Integer.valueOf(0));
                    vo2.setCustomerDefaultFlag(Integer.valueOf(0));
                }
                vo2.setWarnType(warnType);
                vo2.setRowState("add");
                voList.add(vo2);
            }
            this.validate(voList);
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(voList)) {
                voList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    private void validate(List<BankAccountVO> voList) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bankCode", new Parameter("in", voList.stream().map(BankAccountVO::getBankCode).distinct().collect(Collectors.toList())));
        List dataList = super.queryList(queryParam);
        List bankCodes = dataList.stream().map(BankAccountEntity::getBankCode).distinct().collect(Collectors.toList());
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("bankName", new Parameter("in", voList.stream().map(BankAccountVO::getBankName).distinct().collect(Collectors.toList())));
        List bankList = this.bankService.queryList(queryParam2);
        Map bankMap = bankList.stream().collect(Collectors.toMap(x -> x.getName() + "-" + x.getBankCategoryName(), Function.identity(), (x1, x2) -> x1));
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("bankCategoryName", new Parameter("in", voList.stream().map(BankAccountVO::getCategoryName).distinct().collect(Collectors.toList())));
        List categoryList = this.categoryService.queryList(queryParam3);
        Map categoryMap = categoryList.stream().collect(Collectors.toMap(x -> x.getName(), Function.identity(), (x1, x2) -> x1));
        ArrayList successList = new ArrayList();
        ArrayList errorList = new ArrayList();
        if (CollectionUtils.isNotEmpty(voList)) {
            voList.forEach(vo -> {
                if (bankCodes.contains(vo.getBankCode())) {
                    vo.setWarnType(vo.getWarnType() + "\u8d26\u53f7\u5df2\u5b58\u5728");
                }
                if (categoryMap.containsKey(vo.getCategoryName())) {
                    vo.setCategoryId(((BankCategoryEntity)((Object)((Object)categoryMap.get(vo.getCategoryName())))).getId());
                }
                if (bankMap.containsKey(vo.getBankName() + "-" + vo.getCategoryName())) {
                    vo.setBankId(((BankEntity)((Object)((Object)bankMap.get(vo.getBankName() + "-" + vo.getCategoryName())))).getId());
                }
            });
        }
    }
}

