package com.ejianc.foundation.support.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.vo.BankCategoryVO;

/**
 * 银行类别实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("bankCategory")
public class BankCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUPPORT_BANK_CATEGORY_CODE";//此处需要根据实际修改
    
    @Autowired
    private IBankCategoryService service; 

    @Autowired
    private IBankService bankService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BankCategoryVO> saveOrUpdate(@RequestBody BankCategoryVO saveorUpdateVO) {
    	BankCategoryEntity entity = BeanMapper.map(saveorUpdateVO, BankCategoryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	BankCategoryVO vo = BeanMapper.map(entity, BankCategoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankCategoryVO> queryDetail(Long id) {
    	BankCategoryEntity entity = service.selectById(id);
    	BankCategoryVO vo = BeanMapper.map(entity, BankCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        LambdaQueryWrapper<BankEntity> lambda = Wrappers.<BankEntity>lambdaQuery();
        lambda.in(BankEntity::getBankCategoryId, ids);
        lambda.eq(BankEntity::getDr, 0);
        lambda.eq(BankEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<BankEntity> entities = bankService.list(lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entities)) {
            return CommonResponse.error("删除失败！该银行类别已存在银行档案信息，不允许删除");
        } else {
            service.removeByIds(ids, false);
            return CommonResponse.success("删除成功");
        }
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BankCategoryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BankCategoryEntity> page = service.queryPage(param,false);
        IPage<BankCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankCategoryVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBankCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public List<BankCategoryEntity> refBankCategoryData(@RequestParam String searchText) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(searchText)) {
            param.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
        }
        param.getOrderMap().put("code", "asc");
        List<BankCategoryEntity> dataList = service.queryList(param,false);
        if(ListUtil.isEmpty(dataList)){
            return new ArrayList<>();
        }
        return dataList;
     }
}
