package com.ejianc.foundation.support.service.impl;


import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.BankCategoryMapper;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.service.IBankCategoryService;

import java.util.List;


/**
 * 银行类别实体
 * 
 * @author generator
 * 
 */
@Service("bankCategoryService")
public class BankCategoryServiceImpl extends BaseServiceImpl<BankCategoryMapper, BankCategoryEntity> implements IBankCategoryService{
    @Autowired
    private BankCategoryMapper bankCategoryMapper;

    @Override
    public List<BankCategoryEntity> queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return bankCategoryMapper.queryByCode(tenantId, code);
    }
}
