/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.bean.DefdocEntity;
import com.ejianc.foundation.support.service.IDataTransferService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/defdoc/"})
public class DefdocController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    private static final long serialVersionUID = 1L;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IDefdocService defdocService;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IDataTransferService dataTransferService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DefdocVO defdocVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (!this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        if (defdocVo.getId() != null && defdocVo.getId() > 0L) {
            DefdocVO uniqueBean = this.defdocService.queryDetail(defdocVo.getId());
            List<DefdocVO> list = this.defdocService.queryByCode(defdocVo.getCode());
            if (list.size() > 1 || list.size() == 1 && !list.get(0).getId().equals(defdocVo.getId())) {
                return CommonResponse.error((String)("\u4fee\u6539\u5931\u8d25\uff1a\u6863\u6848\u7f16\u7801\u4e0e\u3010" + list.get(0).getName() + "\u3011\u91cd\u590d\uff01"));
            }
            uniqueBean.setCode(defdocVo.getCode());
            uniqueBean.setName(defdocVo.getName());
            uniqueBean.setSequence(defdocVo.getSequence());
            uniqueBean.setDescription(defdocVo.getDescription());
            DefdocEntity defdocEntity = (DefdocEntity)((Object)BeanMapper.map((Object)uniqueBean, DefdocEntity.class));
            this.defdocService.saveOrUpdate((Object)defdocEntity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        DefdocEntity defdocEntity = (DefdocEntity)((Object)BeanMapper.map((Object)defdocVo, DefdocEntity.class));
        List<DefdocVO> list = this.defdocService.queryByCode(defdocVo.getCode());
        if (!ListUtil.isEmpty(list)) {
            return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a\u6863\u6848\u7f16\u7801\u4e0e\u3010" + list.get(0).getName() + "\u3011\u91cd\u590d\uff01"));
        }
        this.defdocService.saveOrUpdate((Object)defdocEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DefdocVO> queryDetail(@RequestParam Long id) {
        DefdocVO defdocVo = this.defdocService.queryDetail(id);
        return CommonResponse.success((Object)defdocVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (!this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        List<DefdocDetailVO> defdocDetails = this.defdocDetailService.queryListByDefdocId(ids);
        if (defdocDetails != null && defdocDetails.size() > 0) {
            return CommonResponse.error((String)"\u8981\u5220\u9664\u7684\u81ea\u5b9a\u4e49\u6863\u6848\u4e0b\u6709\u6863\u6848\u9879\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.defdocService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.defdocService.queryPage(queryParam, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/list/ref"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DefdocEntity>> ref(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        Map param = queryParam.getParams();
        param.put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        if (!StringUtils.isEmpty((String)searchText)) {
            param.put("name", new Parameter("like", (Object)searchText));
        }
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.defdocService.queryPage(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((String)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (publishVO.getIdList() == null) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            List detailEntities = null;
            if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                baseEntities = (List)this.defdocService.listByIds(publishVO.getIdList());
                List<DefdocDetailVO> vos = this.defdocDetailService.queryListByDefdocId(publishVO.getIdList());
                if (vos != null && vos.size() > 0) {
                    detailEntities = BeanMapper.mapList(vos, DefdocDetailEntity.class);
                }
            } else {
                return CommonResponse.error((String)"\u672a\u9009\u4e2d\u8981\u53d1\u5e03\u7684\u6570\u636e");
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (DefdocEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((String)entity.getCode())) continue;
                    codes.add(entity.getCode());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities, detailEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            String url = publishVO.getTarget() + "/ejc-support-web/dataTransfer/transferBySql";
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("sql", sqls);
            this.gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = this.gson.toJson(params);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u6863\u6848\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u53d1\u5e03\u6863\u6848\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
    }

    private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        for (Long l : ids) {
            idStr = idStr + "'" + l + "',";
        }
        String codeStr = "";
        for (String code : codes) {
            codeStr = codeStr + "'" + code + "',";
        }
        idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
        codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
        String string = "ejc_support_defdoc";
        String detailName = "ejc_support_999999_defdoc_detail";
        String detailSql = " delete from " + detailName + " where defdoc_id in " + idStr + ";";
        String deleteBaseSql = " delete from " + string + " where id in " + idStr + ";";
        String deleteByCodeSql = " delete from " + string + " where dr =1 and code in " + codeStr + ";";
        sqlList.add(detailSql);
        sqlList.add(deleteBaseSql);
        sqlList.add(deleteByCodeSql);
        return sqlList;
    }

    private List<String> getInsertSql(List<DefdocEntity> baseEntityList, List<DefdocDetailEntity> detailEntities) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
        ArrayList<String> detailInsertSql = new ArrayList<String>();
        for (DefdocDetailEntity detail : detailEntities) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String insertSql = " insert into ejc_support_999999_defdoc_detail( tenant_id,sync_es_flag,update_time,create_time,id,update_user_code,create_user_code,`dr`,parent_id,defdoc_id,`code`,`name`,`enabled`,inner_code,sequence,description ) values (" + detail.getTenantId() + "," + detail.getSyncEsFlag() + "," + (detail.getUpdateTime() != null ? "'" + sdf.format(detail.getUpdateTime()) + "'" : detail.getUpdateTime()) + "," + (detail.getCreateTime() != null ? "'" + sdf.format(detail.getCreateTime()) + "'" : detail.getCreateTime()) + "," + detail.getId() + ",'',''," + 0 + "," + detail.getParentId() + "," + detail.getDefdocId() + "," + (detail.getCode() != null ? "'" + detail.getCode() + "'" : detail.getCode()) + "," + (detail.getName() != null ? "'" + detail.getName() + "'" : detail.getName()) + "," + detail.getEnabled() + "," + (detail.getInnerCode() != null ? "'" + detail.getInnerCode() + "'" : detail.getInnerCode()) + "," + detail.getSequence() + "," + (detail.getDescription() != null ? "'" + detail.getDescription() + "'" : detail.getDescription()) + ");";
            detailInsertSql.add(insertSql);
        }
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        if (detailInsertSql != null && !detailInsertSql.isEmpty()) {
            retList.addAll(detailInsertSql);
        }
        return retList;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            if (publishVO.getIdList() == null) {
                throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            List detailEntities = null;
            if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                baseEntities = (List)this.defdocService.listByIds(publishVO.getIdList());
                List<DefdocDetailVO> vos = this.defdocDetailService.queryListByDefdocId(publishVO.getIdList());
                if (vos != null && vos.size() > 0) {
                    detailEntities = BeanMapper.mapList(vos, DefdocDetailEntity.class);
                }
            } else {
                throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (DefdocEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((String)entity.getCode())) continue;
                    codes.add(entity.getCode());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities, detailEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("billType.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }

    @ResponseBody
    @RequestMapping(value={"sysOtherTenant"})
    public CommonResponse<String> sysOtherTenant(@RequestBody PublishVO publishVO) {
        try {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List<DefdocDetailEntity> detailEntities = this.defdocDetailService.queryList(queryParam);
            ArrayList<String> detailInsertSql = new ArrayList<String>();
            List<Object> tenantIds = new ArrayList();
            if ("other".equals(publishVO.getScope())) {
                tenantIds = publishVO.getIdList();
            } else {
                CommonResponse tenantList = this.tenantApi.getAllValidTenantId();
                if (tenantList.isSuccess() && tenantList.getData() != null) {
                    tenantIds = (List)tenantList.getData();
                }
            }
            if (tenantIds != null && tenantIds.size() > 0) {
                for (Long l : tenantIds) {
                    if (l == 999999L) continue;
                    for (DefdocDetailEntity detail : detailEntities) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        String insertSql = " insert ignore into ejc_support_" + l + "_defdoc_detail( tenant_id,sync_es_flag,update_time,create_time,id,update_user_code,create_user_code,`dr`,parent_id,defdoc_id,`code`,`name`,`enabled`,inner_code,sequence,description ) values (" + detail.getTenantId() + "," + detail.getSyncEsFlag() + "," + (detail.getUpdateTime() != null ? "'" + sdf.format(detail.getUpdateTime()) + "'" : detail.getUpdateTime()) + "," + (detail.getCreateTime() != null ? "'" + sdf.format(detail.getCreateTime()) + "'" : detail.getCreateTime()) + "," + detail.getId() + ",'',''," + 0 + "," + detail.getParentId() + "," + detail.getDefdocId() + "," + (detail.getCode() != null ? "'" + detail.getCode() + "'" : detail.getCode()) + "," + (detail.getName() != null ? "'" + detail.getName() + "'" : detail.getName()) + "," + detail.getEnabled() + "," + (detail.getInnerCode() != null ? "'" + detail.getInnerCode() + "'" : detail.getInnerCode()) + "," + detail.getSequence() + "," + (detail.getDescription() != null ? "'" + detail.getDescription() + "'" : detail.getDescription()) + ")";
                        detailInsertSql.add(insertSql);
                    }
                }
            }
            if (detailInsertSql != null && detailInsertSql.size() > 0) {
                this.dataTransferService.executeSql(detailInsertSql);
            }
            return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return CommonResponse.error((String)e.getMessage());
        }
    }
}

