package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankAccountMapper;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 银行账户实体
 * 
 * @author generator
 * 
 */
@Service("bankAccountService")
public class BankAccountServiceImpl extends BaseServiceImpl<BankAccountMapper, BankAccountEntity> implements IBankAccountService{

    @Autowired
    private IBankService bankService;

    @Autowired
    private IBankCategoryService categoryService;

    @Autowired
    private ICustomerService customerService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public BankAccountVO insertOrUpdate(BankAccountVO saveorUpdateVO) {
        BankAccountEntity entity = BeanMapper.map(saveorUpdateVO, BankAccountEntity.class);
        // 处理默认
        QueryParam queryParam = new QueryParam();
        if(entity.getSupplierId() != null){
            queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, entity.getSupplierId()));
        }
        if(entity.getCustomerId() != null){
            queryParam.getParams().put("customerId", new Parameter(QueryParam.EQ, entity.getCustomerId()));
        }
        List<BankAccountEntity> list = super.queryList(queryParam);
        if(entity.getId() == null && CollectionUtils.isEmpty(list)){// 新增第一条设为默认
            entity.setDefaultFlag(1);
        }
        // 内部单位
        entity.setInsideState(0);
        Long insideOrgId = entity.getInsideOrgId();
        if(insideOrgId != null){
            entity.setInsideState(1);
            QueryParam param = new QueryParam();
            param.getParams().put("insideOrgId", new Parameter(QueryParam.EQ, insideOrgId));
            // 内部客户
            CustomerEntity customer = customerService.queryList(param).stream().findAny().get();
            entity.setCustomerId(customer.getId());
            entity.setCustomerName(customer.getName());
            // 内部供应商
            SupplierEntity supplier = supplierService.queryList(param).stream().findAny().get();
            entity.setSupplierId(supplier.getId());
            entity.setSupplierName(supplier.getName());
        }
        super.saveOrUpdate(entity, false);
        BankAccountVO vo = BeanMapper.map(entity, BankAccountVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if(result.size()>10000){
                    return CommonResponse.error("超过10000条，请分批上传！");
                }
                // 处理导入文件
                Map<String, Integer> indexMap = new HashMap<>();
                List<BankAccountVO> voList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BankAccountVO vo = new BankAccountVO();
                    String warnType = "";

                    String bankCode = datas.get(0);
                    vo.setBankCode(bankCode);
                    if (indexMap.containsKey(bankCode)) {//账号重复
                        return CommonResponse.error("第"+(i+2)+"行账号和第" + (indexMap.get(bankCode)+2) + "行重复");
                    }else{
                        indexMap.put(bankCode, i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 户名为空
                        vo.setBankAccount(null);
                        warnType = warnType + "[户名为空]";
                    }else{
                        vo.setBankAccount(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//开户银行为空
                        vo.setBankName(null);
                        warnType =  warnType + "[开户银行为空]";
                    } else {
                        vo.setBankName(datas.get(2));
                    }

                    if (StringUtils.isEmpty(datas.get(3))) {//银行类别为空
                        vo.setCategoryName(null);
                        warnType =  warnType + "[银行类别为空]";
                    } else {
                        vo.setCategoryName(datas.get(3));
                    }

                    vo.setMemo(datas.get(4));// 备注

                    if (StringUtils.isEmpty(datas.get(5))) {// 默认为空
                        vo.setDefaultFlag(null);
                        warnType = warnType + "[默认为空]";
                    } else {
                        if ("是".equals(datas.get(5))) {
                            vo.setDefaultFlag(1);
                        } else {
                            vo.setDefaultFlag(0);
                        }
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    voList.add(vo);
                }

                // 根据数据库赋值校验
                this.validate(voList);

                // 处理成功列表和失败列表
                List<BankAccountVO> successList = new ArrayList<>();
                List<BankAccountVO> errorList = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(voList)){
                    voList.forEach(vo ->{
                        if(StringUtils.isEmpty(vo.getWarnType())){
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankAccountVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        String supplierId = null;
        String supplierName = null;
        String customerId = null;
        String customerName = null;
        // 处理默认
        QueryParam param = new QueryParam();
        if(StringUtils.isNotEmpty(request.getParameter("supplierId"))){
            // 供应商
            supplierId = request.getParameter("supplierId");
            supplierName = request.getParameter("supplierName");
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        }
        if(StringUtils.isNotEmpty(request.getParameter("customerId"))){
            // 客户
            customerId = request.getParameter("customerId");
            customerName = request.getParameter("customerName");
            param.getParams().put("customerId", new Parameter(QueryParam.EQ, customerId));
        }
        List<BankAccountEntity> dataList = super.queryList(param);
        Boolean defaultFlag = false;
        for(BankAccountVO vo : importVOS){
            if(NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag())){
                defaultFlag = true;
            }
        }
        if(!defaultFlag && CollectionUtils.isEmpty(dataList)){// 新增第一条，且没有默认值设为默认
            importVOS.get(0).setDefaultFlag(1);
        }
        if(defaultFlag && CollectionUtils.isNotEmpty(dataList)){// 如果引入有默认，把之前的默认修改
            List<BankAccountEntity> list = dataList.stream().filter(x->NumberUtils.INTEGER_ONE.equals(x.getDefaultFlag())).collect(Collectors.toList());
            list.forEach(x->{
                x.setDefaultFlag(0);
            });
            super.saveOrUpdateBatch(list);
        }

        // 内部客商
        String insideOrgId = null;
        if(StringUtils.isNotEmpty(request.getParameter("insideOrgId"))){
            QueryParam queryParam = new QueryParam();
            insideOrgId = request.getParameter("insideOrgId");
            queryParam.getParams().put("insideOrgId", new Parameter(QueryParam.EQ, insideOrgId));
            if(StringUtils.isNotEmpty(supplierId)){
                // 客户
                CustomerEntity customer = customerService.queryList(queryParam).stream().findAny().get();
                customerId = String.valueOf(customer.getId());
                customerName = customer.getName();
            }
            if(StringUtils.isNotEmpty(customerId)){
                // 供应商
                SupplierEntity supplier = supplierService.queryList(queryParam).stream().findAny().get();
                supplierId = String.valueOf(supplier.getId());
                supplierName = supplier.getName();
            }
        }

        List<BankAccountEntity> list = new ArrayList<>();
        for(BankAccountVO importVO : importVOS){
            if(StringUtils.isNotEmpty(supplierId)){// 供应商
                importVO.setSupplierId(Long.valueOf(supplierId));
                importVO.setSupplierName(supplierName);
            }
            if(StringUtils.isNotEmpty(customerId)){// 客户
                importVO.setCustomerId(Long.valueOf(customerId));
                importVO.setCustomerName(customerName);
            }
            importVO.setInsideState(0);// 是否内部单位银行账户 1-是 0-否
            if(StringUtils.isNotEmpty(insideOrgId)){
                importVO.setInsideOrgId(Long.valueOf(insideOrgId));// 内部客商--来源组织id(青岛市政）
                importVO.setInsideState(1);
            }
            list.add(BeanMapper.map(importVO, BankAccountEntity.class));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        return "保存成功！";
    }

    @Override
    public String enabled(List<BankAccountVO> vos) {
        if(CollectionUtils.isEmpty(vos)){
            return "未选择单据！";
        }
        List<Long> ids = vos.stream().map(BankAccountVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<BankAccountEntity> entityList = super.queryList(queryParam);
        for(BankAccountEntity entity : entityList){
            if (NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())){
                throw new BusinessException("【" + entity.getBankCode() + "】为默认银行账户，不允许停用！");
            }
            // 启用/停用
            Integer enabled = vos.get(0).getEnabled();
            entity.setEnabled(enabled);
            if(enabled == 1){
                entity.setEnableUserId(InvocationInfoProxy.getUserid());
                entity.setEnableUserName(sessionManager.getUserContext().getUserName());
                entity.setEnableTime(new Date());
            }
            if(enabled == 0){
                entity.setUnenableUserId(InvocationInfoProxy.getUserid());
                entity.setUnenableUserName(sessionManager.getUserContext().getUserName());
                entity.setUnenableTime(new Date());
            }
        }
        if(CollectionUtils.isNotEmpty(entityList)){
            super.saveOrUpdateBatch(entityList);
        }
        return "操作成功！";
    }

    @Override
    public String defaultFlag(BankAccountVO vo) {
        BankAccountEntity entity = super.selectById(vo.getId());
        if(!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())){
            throw new BusinessException("已经为非默认银行账户！");
        }
        if(NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())){
            throw new BusinessException("已经为默认银行账户！");
        }
        if(!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())){
            throw new BusinessException("至少有一个为默认银行账户！");
        }
        if(NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getEnabled())){
            throw new BusinessException("该银行账户已停用！");
        }
        // 处理默认
        QueryParam param = new QueryParam();
        if(entity.getSupplierId() != null){
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, entity.getSupplierId()));
        }
        if(entity.getCustomerId() != null){
            param.getParams().put("customerId", new Parameter(QueryParam.EQ, entity.getCustomerId()));
        }
        param.getParams().put("defaultFlag", new Parameter(QueryParam.EQ, 1));
        List<BankAccountEntity> dataList = super.queryList(param);
        if(NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && CollectionUtils.isNotEmpty(dataList)){// 如果引入有默认，把之前的默认修改
            dataList.forEach(x->{
                x.setDefaultFlag(0);
            });
            super.saveOrUpdateBatch(dataList);
        }
        entity.setDefaultFlag(1);
        super.saveOrUpdate(entity, false);
        return "操作成功！";
    }

    /**
     * 根据数据库赋值校验
     * @param voList
     * @return
     */
    private void validate(List<BankAccountVO> voList) {
        // 查询数据库
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bankCode", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getBankCode).distinct().collect(Collectors.toList())));
        List<BankAccountEntity> dataList = super.queryList(queryParam);
        List<String> bankCodes = dataList.stream().map(BankAccountEntity::getBankCode).distinct().collect(Collectors.toList());

        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("bankName", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getBankName).distinct().collect(Collectors.toList())));
        List<BankEntity> bankList = bankService.queryList(queryParam2);
        Map<String, BankEntity> bankMap = bankList.stream().collect(Collectors.toMap(x->x.getName() + "-" + x.getBankCategoryName(), Function.identity(), (x1, x2) -> x1));

        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("bankCategoryName", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getCategoryName).distinct().collect(Collectors.toList())));
        List<BankCategoryEntity> categoryList = categoryService.queryList(queryParam3);
        Map<String, BankCategoryEntity> categoryMap = categoryList.stream().collect(Collectors.toMap(x->x.getName(), Function.identity(), (x1, x2) -> x1));

        // 处理成功列表和失败列表
        List<BankAccountVO> successList = new ArrayList<>();
        List<BankAccountVO> errorList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(voList)){
            voList.forEach(vo ->{
                // 校验账户是否存在
                if(bankCodes.contains(vo.getBankCode())){
                    vo.setWarnType(vo.getWarnType() + "账号已存在");
                }
                // 添加银行分类主键
                if(categoryMap.containsKey(vo.getCategoryName())){
                    vo.setCategoryId(categoryMap.get(vo.getCategoryName()).getId());
                } else {
                    vo.setWarnType(vo.getWarnType() + "银行类别不存在");
                }
                // 添加银行档案主键
                if(bankMap.containsKey(vo.getBankName() + "-" + vo.getCategoryName())){
                    vo.setBankId(bankMap.get(vo.getBankName() + "-" + vo.getCategoryName()).getId());
                } else {
                    vo.setWarnType(vo.getWarnType() + "银行档案不存在");
                }
            });
        }
    }
}
