/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankAccountMapper;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="bankAccountService")
public class BankAccountServiceImpl
extends BaseServiceImpl<BankAccountMapper, BankAccountEntity>
implements IBankAccountService {
    @Autowired
    private IBankService bankService;
    @Autowired
    private IBankCategoryService categoryService;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public BankAccountVO insertOrUpdate(BankAccountVO saveorUpdateVO) {
        BankAccountEntity entity = (BankAccountEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BankAccountEntity.class));
        QueryParam queryParam = new QueryParam();
        if (entity.getSupplierId() != null) {
            queryParam.getParams().put("supplierId", new Parameter("eq", (Object)entity.getSupplierId()));
        }
        if (entity.getCustomerId() != null) {
            queryParam.getParams().put("customerId", new Parameter("eq", (Object)entity.getCustomerId()));
        }
        List list = super.queryList(queryParam);
        if (entity.getId() == null && CollectionUtils.isEmpty((Collection)list)) {
            entity.setDefaultFlag(1);
        }
        entity.setInsideState(0);
        Long insideOrgId = entity.getInsideOrgId();
        if (insideOrgId != null) {
            entity.setInsideState(1);
            QueryParam param = new QueryParam();
            param.getParams().put("insideOrgId", new Parameter("eq", (Object)insideOrgId));
            CustomerEntity customer = (CustomerEntity)((Object)this.customerService.queryList(param).stream().findAny().get());
            entity.setCustomerId(customer.getId());
            entity.setCustomerName(customer.getName());
            SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.queryList(param).stream().findAny().get());
            entity.setSupplierId(supplier.getId());
            entity.setSupplierName(supplier.getName());
        }
        super.saveOrUpdate((Object)entity, false);
        BankAccountVO vo = (BankAccountVO)BeanMapper.map((Object)((Object)entity), BankAccountVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BankAccountVO> voList = new ArrayList<BankAccountVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BankAccountVO vo2 = new BankAccountVO();
                String warnType = "";
                String bankCode = (String)datas.get(0);
                vo2.setBankCode(bankCode);
                if (indexMap.containsKey(bankCode)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u8d26\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(bankCode) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(bankCode, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo2.setBankAccount(null);
                    warnType = warnType + "[\u6237\u540d\u4e3a\u7a7a]";
                } else {
                    vo2.setBankAccount((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo2.setBankName(null);
                    warnType = warnType + "[\u5f00\u6237\u94f6\u884c\u4e3a\u7a7a]";
                } else {
                    vo2.setBankName((String)datas.get(2));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    vo2.setCategoryName(null);
                    warnType = warnType + "[\u94f6\u884c\u7c7b\u522b\u4e3a\u7a7a]";
                } else {
                    vo2.setCategoryName((String)datas.get(3));
                }
                vo2.setMemo((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo2.setDefaultFlag(null);
                    warnType = warnType + "[\u9ed8\u8ba4\u4e3a\u7a7a]";
                } else if ("\u662f".equals(datas.get(5))) {
                    vo2.setDefaultFlag(Integer.valueOf(1));
                } else {
                    vo2.setDefaultFlag(Integer.valueOf(0));
                }
                vo2.setWarnType(warnType);
                vo2.setRowState("add");
                voList.add(vo2);
            }
            this.validate(voList);
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(voList)) {
                voList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankAccountVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String supplierId = null;
        String supplierName = null;
        String customerId = null;
        String customerName = null;
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("supplierId"))) {
            supplierId = request.getParameter("supplierId");
            supplierName = request.getParameter("supplierName");
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("customerId"))) {
            customerId = request.getParameter("customerId");
            customerName = request.getParameter("customerName");
            param.getParams().put("customerId", new Parameter("eq", (Object)customerId));
        }
        List dataList = super.queryList(param);
        Boolean defaultFlag = false;
        for (BankAccountVO vo : importVOS) {
            if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag())) continue;
            defaultFlag = true;
        }
        if (!defaultFlag.booleanValue() && CollectionUtils.isEmpty((Collection)dataList)) {
            importVOS.get(0).setDefaultFlag(Integer.valueOf(1));
        }
        if (defaultFlag.booleanValue() && CollectionUtils.isNotEmpty((Collection)dataList)) {
            List<BankAccountEntity> list = dataList.stream().filter(x -> NumberUtils.INTEGER_ONE.equals(x.getDefaultFlag())).collect(Collectors.toList());
            list.forEach(x -> x.setDefaultFlag(0));
            super.saveOrUpdateBatch(list);
        }
        String insideOrgId = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("insideOrgId"))) {
            QueryParam queryParam = new QueryParam();
            insideOrgId = request.getParameter("insideOrgId");
            queryParam.getParams().put("insideOrgId", new Parameter("eq", (Object)insideOrgId));
            if (StringUtils.isNotEmpty((CharSequence)supplierId)) {
                CustomerEntity customer = (CustomerEntity)((Object)this.customerService.queryList(queryParam).stream().findAny().get());
                customerId = String.valueOf(customer.getId());
                customerName = customer.getName();
            }
            if (StringUtils.isNotEmpty((CharSequence)customerId)) {
                SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.queryList(queryParam).stream().findAny().get());
                supplierId = String.valueOf(supplier.getId());
                supplierName = supplier.getName();
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (BankAccountVO importVO : importVOS) {
            if (StringUtils.isNotEmpty((CharSequence)supplierId)) {
                importVO.setSupplierId(Long.valueOf(supplierId));
                importVO.setSupplierName(supplierName);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerId)) {
                importVO.setCustomerId(Long.valueOf(customerId));
                importVO.setCustomerName(customerName);
            }
            importVO.setInsideState(Integer.valueOf(0));
            if (StringUtils.isNotEmpty((CharSequence)insideOrgId)) {
                importVO.setInsideOrgId(Long.valueOf(insideOrgId));
                importVO.setInsideState(Integer.valueOf(1));
            }
            list.add(BeanMapper.map((Object)importVO, BankAccountEntity.class));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            super.saveOrUpdateBatch(list);
        }
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }

    @Override
    public String enabled(List<BankAccountVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return "\u672a\u9009\u62e9\u5355\u636e\uff01";
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List entityList = super.queryList(queryParam);
        for (BankAccountEntity entity : entityList) {
            if (NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
                throw new BusinessException("\u3010" + entity.getBankCode() + "\u3011\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff01");
            }
            Integer enabled = vos.get(0).getEnabled();
            entity.setEnabled(enabled);
            if (enabled == 1) {
                entity.setEnableUserId(InvocationInfoProxy.getUserid());
                entity.setEnableUserName(this.sessionManager.getUserContext().getUserName());
                entity.setEnableTime(new Date());
            }
            if (enabled != 0) continue;
            entity.setUnenableUserId(InvocationInfoProxy.getUserid());
            entity.setUnenableUserName(this.sessionManager.getUserContext().getUserName());
            entity.setUnenableTime(new Date());
        }
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.saveOrUpdateBatch((Collection)entityList);
        }
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }

    @Override
    public String defaultFlag(BankAccountVO vo) {
        BankAccountEntity entity = (BankAccountEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u5df2\u7ecf\u4e3a\u975e\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u5df2\u7ecf\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u81f3\u5c11\u6709\u4e00\u4e2a\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getEnabled())) {
            throw new BusinessException("\u8be5\u94f6\u884c\u8d26\u6237\u5df2\u505c\u7528\uff01");
        }
        QueryParam param = new QueryParam();
        if (entity.getSupplierId() != null) {
            param.getParams().put("supplierId", new Parameter("eq", (Object)entity.getSupplierId()));
        }
        if (entity.getCustomerId() != null) {
            param.getParams().put("customerId", new Parameter("eq", (Object)entity.getCustomerId()));
        }
        param.getParams().put("defaultFlag", new Parameter("eq", (Object)1));
        List dataList = super.queryList(param);
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.forEach(x -> x.setDefaultFlag(0));
            super.saveOrUpdateBatch((Collection)dataList);
        }
        entity.setDefaultFlag(1);
        super.saveOrUpdate((Object)entity, false);
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }

    private void validate(List<BankAccountVO> voList) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bankCode", new Parameter("in", voList.stream().map(BankAccountVO::getBankCode).distinct().collect(Collectors.toList())));
        List dataList = super.queryList(queryParam);
        List bankCodes = dataList.stream().map(BankAccountEntity::getBankCode).distinct().collect(Collectors.toList());
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("bankName", new Parameter("in", voList.stream().map(BankAccountVO::getBankName).distinct().collect(Collectors.toList())));
        List bankList = this.bankService.queryList(queryParam2);
        Map bankMap = bankList.stream().collect(Collectors.toMap(x -> x.getName() + "-" + x.getBankCategoryName(), Function.identity(), (x1, x2) -> x1));
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("bankCategoryName", new Parameter("in", voList.stream().map(BankAccountVO::getCategoryName).distinct().collect(Collectors.toList())));
        List categoryList = this.categoryService.queryList(queryParam3);
        Map categoryMap = categoryList.stream().collect(Collectors.toMap(x -> x.getName(), Function.identity(), (x1, x2) -> x1));
        ArrayList successList = new ArrayList();
        ArrayList errorList = new ArrayList();
        if (CollectionUtils.isNotEmpty(voList)) {
            voList.forEach(vo -> {
                if (bankCodes.contains(vo.getBankCode())) {
                    vo.setWarnType(vo.getWarnType() + "\u8d26\u53f7\u5df2\u5b58\u5728");
                }
                if (categoryMap.containsKey(vo.getCategoryName())) {
                    vo.setCategoryId(((BankCategoryEntity)((Object)((Object)categoryMap.get(vo.getCategoryName())))).getId());
                } else {
                    vo.setWarnType(vo.getWarnType() + "\u94f6\u884c\u7c7b\u522b\u4e0d\u5b58\u5728");
                }
                if (bankMap.containsKey(vo.getBankName() + "-" + vo.getCategoryName())) {
                    vo.setBankId(((BankEntity)((Object)((Object)bankMap.get(vo.getBankName() + "-" + vo.getCategoryName())))).getId());
                } else {
                    vo.setWarnType(vo.getWarnType() + "\u94f6\u884c\u6863\u6848\u4e0d\u5b58\u5728");
                }
            });
        }
    }
}

