package com.ejianc.foundation.support.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 参照管理显示字段实体
 */
@TableName("ejc_support_refer_showfield")
public class ReferShowfieldEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;
	
	/**
     * 参照定义主表id
     */
    @TableField(value = "refer_id")
    private Long referId;
	
	/**
     * 字段编号
     */
    @TableField(value = "code")
    private String code;
	
	/**
     * 字段名称
     */
    @TableField(value = "name")
    private String name;
	
	/**
     * 字段类型
     */
    @TableField(value = "type")
    private String type;
	
	/**
     * 是否隐藏
     */
    @TableField(value = "hidden")
    private boolean hidden;

	/**
     * 移动端是否显示，默认不显示
     */
    @TableField(value = "mobile_show")
    private boolean mobileShow;

	/**
	 *	是否搜索字段
	 */
    @TableField(value = "inner_filter")
	private boolean innerFilter;
	
	/**
     * 显示顺序
     */
    @TableField(value = "show_order")
    private String showOrder;

	@TableField(value = "format")
	private String format; // 列显示格式(当为时间显示时分秒，小数位的显示数量等等)

	@TableField(value = "align")
	private String align; // 对齐方式

	public Long getReferId() {
		return referId;
	}

	public void setReferId(Long referId) {
		this.referId = referId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public boolean getHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}

	public boolean getMobileShow() {
		return mobileShow;
	}

	public void setMobileShow(boolean mobileShow) {
		this.mobileShow = mobileShow;
	}

	public String getShowOrder() {
		return showOrder;
	}

	public void setShowOrder(String showOrder) {
		this.showOrder = showOrder;
	}

	public boolean getInnerFilter() {
		return innerFilter;
	}

	public void setInnerFilter(boolean innerFilter) {
		this.innerFilter = innerFilter;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getAlign() {
		return align;
	}

	public void setAlign(String align) {
		this.align = align;
	}

}
