package com.ejianc.foundation.share.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;

/**
 * 客户分类
 * 
 * @author guoming
 *
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
@Controller
@RequestMapping("/customer/category/")
public class CustomerCategoryController implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final String CUSTOMER_CATEGORY_BILL_CODE = "SUPPORT_CUSTOMER_CATEGORY";
	
	@Autowired
	private ICustomerCategoryService customerCategoryService;
	@Autowired
	private ICustomerService customerService;
	@Autowired
	private IBillCodeGenerator generator;

    @Value("${insideCustomerCategoryCode:CC-inside}")
    private String insideCustomerCategoryCode;//内部客户分类编码

	/**
	 * 新增或者修改
	 * 
	 * @param CustomerVO
	 * @return
	 * @throws BillCodeException 
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody CustomerCategoryVO customerCategoryVo) throws BillCodeException {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(customerCategoryVo.getId() != null && customerCategoryVo.getId() > 0) {
			CustomerCategoryEntity uniqueBean = customerCategoryService.queryDetail(customerCategoryVo.getId());
			uniqueBean.setCode(customerCategoryVo.getCode());
			uniqueBean.setName(customerCategoryVo.getName());
			uniqueBean.setSequence(customerCategoryVo.getSequence());
			uniqueBean.setDescription(customerCategoryVo.getDescription());
			customerCategoryService.saveOrUpdate(uniqueBean, false);
			
			return CommonResponse.success("修改成功");
		} else {
			String billCode = generator.generateBillCodeById(CUSTOMER_CATEGORY_BILL_CODE, tenantId);
			customerCategoryVo.setCode(billCode);
			CustomerCategoryEntity customerCategoryEntity = BeanMapper.map(customerCategoryVo, CustomerCategoryEntity.class);
			customerCategoryEntity.setId(IdWorker.getId());
			if(customerCategoryEntity.getParentId() != null && customerCategoryEntity.getParentId() > 0) {
				CustomerCategoryEntity uniqueBean = customerCategoryService.queryDetail(customerCategoryEntity.getParentId());
				customerCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + customerCategoryEntity.getId());
			} else {
				customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
			}
			customerCategoryService.saveOrUpdate(customerCategoryEntity, false);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 根据主键ID查询客户分类详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<CustomerCategoryVO> queryDetail(@RequestParam Long id) {
		CustomerCategoryEntity entity = customerCategoryService.queryDetail(id);
		if(entity != null) {
			return CommonResponse.success(BeanMapper.map(entity, CustomerCategoryVO.class));
		}else{
			return CommonResponse.error("查询失败，参数错误！");
		}
	}
	
	/**
	 * 删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		//先查询该分类下有没有子节点
		List<CustomerCategoryVO> children = customerCategoryService.queryListByPid(id);
		if(children != null && children.size() > 0) {
			return CommonResponse.error("该分类有子节点不允许删除");
		}else{
			//查询该分类下有没有客户信息
			List<CustomerVO> customerList = customerService.queryListByCategoryId(id);
			if(customerList != null && customerList.size() > 0) {
				return CommonResponse.error("该分类下已有客户信息，不允许删除");
			}else{
				customerCategoryService.delete(id);
				return CommonResponse.success("删除成功");
			}
		}
	}
	
	/**
	 * 查询客户分类分页列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getOrderMap().put("sequence", "asc");
		List<CustomerCategoryEntity> dataList = customerCategoryService.queryList(queryParam, false);
		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
//    	Map map = null;
//    	for(CustomerCategoryEntity entity: dataList) {
//    		map = new HashMap<>();
//    		map.put("id", entity.getId());
//    		map.put("key", entity.getId());
//    		map.put("title", entity.getName());
//    		map.put("parentId", entity.getParentId());
//    		resultMapList.add(map);
//    	}
//    	List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
//    	
//		JSONObject jsonObject = new JSONObject();
//		jsonObject.put("data", result);
		return CommonResponse.success(jsonObject);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/4/30 客户分类树
	 * @Description queryRefTree
	 * @Param [searchText]
	 * @Return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
	 */
	@RequestMapping(value = "/queryRefTree", method = RequestMethod.GET)
	@ResponseBody
	public List<Map<String, Object>> queryRefTree(@RequestParam(value = "searchText", required = false) String searchText) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if(StringUtils.isNotBlank(searchText)) {
			queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
		}
		queryParam.getParams().put("code", new Parameter(QueryParam.NE, insideCustomerCategoryCode));
		queryParam.getOrderMap().put("sequence", "asc");
		List<CustomerCategoryEntity> dataList = customerCategoryService.queryList(queryParam, false);
		if(ListUtil.isEmpty(dataList)){
			return new ArrayList<>();
		}
		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		return ResultAsTree.createTreeData(resultMapList);
	}
}
