package com.ejianc.foundation.share.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;

/**
 * 客户分类
 * 
 * @author guoming
 *
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
@Controller
@RequestMapping("/supplier/category/")
public class SupplierCategoryController implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final String SUPPLIER_CATEGORY_BILL_CODE = "SUPPORT_SUPPLIER_CATEGORY";
	
	@Autowired
	private ISupplierCategoryService supplierCategoryService;
	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private IBillCodeGenerator generator;

    @Value("${insideSupplierCategoryCode:SPC-inside}")
    private String insideSupplierCategoryCode;//内部供应商分类编码

	/**
	 * 新增或者修改
	 * 
	 * @param SupplierVO
	 * @return
	 * @throws BillCodeException 
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody SupplierCategoryVO supplierCategoryVo) throws BillCodeException {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(supplierCategoryVo.getId() != null && supplierCategoryVo.getId() > 0) {
			SupplierCategoryEntity uniqueBean = supplierCategoryService.queryDetail(supplierCategoryVo.getId());
			uniqueBean.setCode(supplierCategoryVo.getCode());
			uniqueBean.setName(supplierCategoryVo.getName());
			uniqueBean.setSequence(supplierCategoryVo.getSequence());
			uniqueBean.setDescription(supplierCategoryVo.getDescription());
			supplierCategoryService.saveOrUpdate(uniqueBean, false);
			
			return CommonResponse.success("修改成功");
		} else {
			String billCode = generator.generateBillCodeById(SUPPLIER_CATEGORY_BILL_CODE, tenantId);
			supplierCategoryVo.setCode(billCode);
			SupplierCategoryEntity supplierCategoryEntity = BeanMapper.map(supplierCategoryVo, SupplierCategoryEntity.class);
			supplierCategoryEntity.setId(IdWorker.getId());
			if(supplierCategoryEntity.getParentId() != null && supplierCategoryEntity.getParentId() > 0) {
				SupplierCategoryEntity uniqueBean = supplierCategoryService.queryDetail(supplierCategoryEntity.getParentId());
				supplierCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + supplierCategoryEntity.getId());
			} else {
				supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
			}
			supplierCategoryService.saveOrUpdate(supplierCategoryEntity, false);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 根据主键ID查询供方分类详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierCategoryVO> queryDetail(@RequestParam Long id) {
		SupplierCategoryEntity entity = supplierCategoryService.queryDetail(id);
		if(entity != null) {
			return CommonResponse.success(BeanMapper.map(entity, SupplierCategoryVO.class));
		}else{
			return CommonResponse.error("查询失败，参数错误！");
		}
	}
	
	/**
	 * 删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		//先查询该分类下有没有子节点
		List<SupplierCategoryVO> children = supplierCategoryService.queryListByPid(id);
		if(children != null && children.size() > 0) {
			return CommonResponse.error("该分类有子节点不允许删除");
		}else{
			//查询该分类下有没有客户信息
			List<SupplierVO> supplierList = supplierService.queryListByCategoryId(id);
			if(supplierList != null && supplierList.size() > 0) {
				return CommonResponse.error("该分类下已有供方信息，不允许删除");
			}else{
				supplierCategoryService.delete(id);
				return CommonResponse.success("删除成功");
			}
		}
	}
	
	/**
	 * 查询供方分类分页列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getOrderMap().put("sequence", "asc");
		List<SupplierCategoryEntity> dataList = supplierCategoryService.queryList(queryParam, false);

		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
//		List<Map> resultMapList = new ArrayList<Map>();
//    	Map map = null;
//    	for(SupplierCategoryEntity entity: dataList) {
//    		map = new HashMap<>();
//    		map.put("id", entity.getId());
//    		map.put("key", entity.getId());
//    		map.put("title", entity.getName());
//    		map.put("parentId", entity.getParentId());
//    		resultMapList.add(map);
//    	}
//    	List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
//    	
//		JSONObject jsonObject = new JSONObject();
//		jsonObject.put("data", result);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 供方分类树
	 * 
	 * @param condition
	 * @param searchText
	 * @return
	 */
	@RequestMapping(value = "/querySupplierRefTree", method = RequestMethod.GET)
	@ResponseBody
    public List<Map<String, Object>> querySupplierRefTree(@RequestParam(required = false) String searchText) {
        try {
    		QueryParam queryParam = new QueryParam();
    		if(StringUtils.isNotBlank(searchText)) {
    			queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
    		}
    		
    		queryParam.getParams().put("code", new Parameter(QueryParam.NE, insideSupplierCategoryCode));
    		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    		queryParam.getOrderMap().put("sequence", "asc");
    		List<SupplierCategoryEntity> dataList = supplierCategoryService.queryList(queryParam, false);
    		
    		List<Map> resultMapList = new ArrayList<Map>();
        	Map map = null;
        	for(SupplierCategoryEntity entity: dataList) {
        		map = new HashMap<>();
        		map.put("id", entity.getId());
        		map.put("key", entity.getId());
        		map.put("name", entity.getName());
        		map.put("title", entity.getName());
        		map.put("parentId", entity.getParentId());
        		resultMapList.add(map);
        	}
        	List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
        	return result;
        } catch (Exception e) {
            return null;
        }
    }
}
