package com.ejianc.foundation.support.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankMapper;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;


/**
 * 银行档案实体
 * 
 * @author generator
 * 
 */
@Service("bankService")
public class BankServiceImpl extends BaseServiceImpl<BankMapper, BankEntity> implements IBankService {

    @Autowired
    private BankMapper bankMapper;

    @Autowired
    private IBillCodeGenerator generator;

    private static final String BILL_CODE = "SUPPORT_BANK_CODE";//此处需要根据实际修改

    @Autowired
    private IBankCategoryService bankCategoryService;

    @Override
    public void updateEnabled(BankVO bankVo) {
        BankEntity bankEntity = this.selectById(bankVo.getId());
        bankEntity.setEnabled(bankVo.getEnabled());
        saveOrUpdate(bankEntity);
    }

    @Override
    public BankVO queryExitFlag(String name, String shortName, String bankCategoryName, String address, Long bankCategoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BankVO bankVo = bankMapper.queryExitFlag(tenantId, name, shortName, bankCategoryName, address, bankCategoryId);
        return bankVo;
    }

    @Override
    public BankEntity selectByCode(String code) {
        LambdaQueryWrapper<BankEntity> lambda = new LambdaQueryWrapper<BankEntity>();
        lambda.eq(BankEntity::getCode,code);
        lambda.eq(BankEntity::getDr,0);
        lambda.eq(BankEntity::getTenantId,InvocationInfoProxy.getTenantid());
        BankEntity bankEntity = bankMapper.selectOne(lambda);
        return bankEntity;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                if(result.size()>10000){
                    return CommonResponse.error("信息超过10000条，请分批上传！");
                }
                // 处理导入文件
                Map<String, Integer> indexMap = new HashMap<>();
                List<BankVO> voList = new ArrayList<>();
                for(int i=0;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    String warnType = "";
                    BankVO bank = new BankVO();;
                    bank.setId(IdWorker.getId());
                    if (StringUtils.isEmpty(datas.get(0))){
                        bank.setBankCategoryId(null);
                        bank.setBankCategoryName(null);
                        warnType += "[银行类别名称为空]";
                    }else {
                        //通过银行名称获取银行分类ID
                        List<BankCategoryEntity> bankCategoryEntities = bankCategoryService.queryByName(String.valueOf(datas.get(0)));
                        bank.setBankCategoryId(bankCategoryEntities.get(0).getId());
                        bank.setBankCategoryName(bankCategoryEntities.get(0).getName());
                        if (CollectionUtils.isEmpty(bankCategoryEntities)) {
                            warnType += "[银行类别名称错误]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(1))) {
                        try {
                            String billCode = generator.generateBillCodeById(BILL_CODE, tenantId);
                            bank.setCode(billCode);
                        } catch (BillCodeException e) {
                            bank.setCode(String.valueOf(new Date().getTime()));
                        }
                    } else {
                        String bankCode = datas.get(1);
                        bank.setCode(bankCode);
                        if (indexMap.containsKey(bankCode)) {//编码重复
                            return CommonResponse.error("第"+(i+2)+"行银行编码和第" + (indexMap.get(bankCode)+2) + "行重复");
                        }else{
                            indexMap.put(bankCode, i);
                        }
                        BankEntity bankEntity = this.selectByCode(datas.get(1));
                        if (bankEntity != null) {
                            //bank.setCode(null);
                            warnType += "[银行编码重复]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(2))) {
                        bank.setName(null);
                        warnType += "[银行名称为空]";
                    }else{
                        bank.setName(datas.get(2));
                    }
                    bank.setShortName(datas.get(3));
                    bank.setAddress(datas.get(4));
                    bank.setWarnType(warnType);
                    bank.setRowState("add");
                    voList.add(bank);
                }
                // 处理成功列表和失败列表
                List<BankVO> successList = new ArrayList<>();
                List<BankVO> errorList = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(voList)){
                    voList.forEach(vo ->{
                        if(StringUtils.isEmpty(vo.getWarnType())){
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<BankEntity> list = new ArrayList<>();
        for(BankVO importVO : importVOS){
            list.add(BeanMapper.map(importVO, BankEntity.class));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        return "保存成功！";
    }

    public Integer updateCategoryNameByCategoryId(Long bankCategoryId,String bankCategoryName){
        return bankMapper.updateCategoryNameByCategoryId(bankCategoryId,bankCategoryName,InvocationInfoProxy.getTenantid());
    }


}