package com.ejianc.foundation.support.service;

import com.ejianc.foundation.support.bean.BillCodeRuleAttrEntity;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface IBillCodeRuleAttrService extends IBaseService<BillCodeRuleAttrEntity> {

    /**
     * 保存/更新单据编码规则子元素
     *
     * @param attrs 单据编码规则子元素
     * @param billCodeRuleId 单据编码规则主键Id
     * @param b 保存前是否保存进行删除操作，true-删除
     */
    void save(List<BillCodeRuleAttrVO> attrs, Long billCodeRuleId, boolean b);

    /**
     * 查询条件匹配的单据编码规则资源数列表
     *
     * @param param
     * @param isEs
     * @return
     */
    List<BillCodeRuleAttrVO> getListByProperties(QueryParam param, boolean isEs);
}
