package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 供方
 *
 * @author guoming
 *
 */
@TableName("ejc_support_supplier")
public class SupplierEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "code")
	private String code; // 供方编码

	@TableField(value = "name")
	private String name; // 供方名称

	@TableField(value = "category_id")
	private Long categoryId; // 供方分类ID

	@TableField(exist = false)
	private String categoryName; // 供方分类名称

	@TableField(value = "social_credit_code")
	private String socialCreditCode; // 社会信用代码

	@TableField(value = "legal")
	private String legal; // 法定代表人

	@TableField(value = "tax_payer_type")
	private Long taxPayerType; // 纳税人类型

	@TableField(value = "business_scope")
	private String businessScope; // 经营范围

	@TableField(value = "enabled")
	private Integer enabled; // 合作不合作（1：合作 ， 0：不合作）

	@TableField(value = "area")
	private String area; // 地区

	@TableField(value = "address")
	private String address; // 详细地址

	@TableField(value = "telephone")
	private String telephone; // 客户电话

	@TableField(value = "bank_name")
	private String bankName; // 账户名

	@TableField(value = "bank_account")
	private String bankAccount;// 银行账号

	@TableField(value = "bank_code")
	private String bankCode; // 开户行

	@TableField(value = "description")
	private String description; // 描述

	@TableField(value = "source_id")
	private String sourceId; // 来源id

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "tenant")
	private Long tenant; // 关联租户id（供方协同）

	@TableField(value = "tenant_name")
	private String tenantName; // 关联租户名称（供方协同）

	@TableField(value = "tenant_phone")
	private String tenantPhone; // 生成租户手机号（供方协同）

	@TableField(value = "tenant_user_name")
	private String tenantUserName; // 生成租户管理员名称（供方协同）

	/**
	 * 省份
	 */
	@TableField(value = "province")
	private String province;

	/**
	 * 市区
	 */
	@TableField(value = "city")
	private String city;

	/**
	 * 区县
	 */
	@TableField(value = "region")
	private String region;

	@TableField(value = "org_id")
	private Long orgId; // 所属组织ID

	@TableField(value = "inside_org_id")
	private Long insideOrgId; // 内部客商--来源组织id(青岛市政）
	@TableField(value = "org_name")
	private String orgName; // 所属组织

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getLegal() {
		return legal;
	}

	public void setLegal(String legal) {
		this.legal = legal;
	}

	public Long getTaxPayerType() {
		return taxPayerType;
	}

	public void setTaxPayerType(Long taxPayerType) {
		this.taxPayerType = taxPayerType;
	}

	public String getBusinessScope() {
		return businessScope;
	}

	public void setBusinessScope(String businessScope) {
		this.businessScope = businessScope;
	}

	public Integer getEnabled() {
		return enabled;
	}

	public void setEnabled(Integer enabled) {
		this.enabled = enabled;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public Long getTenant() {
		return tenant;
	}

	public void setTenant(Long tenant) {
		this.tenant = tenant;
	}

	public String getTenantName() {
		return tenantName;
	}

	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	public String getTenantPhone() {
		return tenantPhone;
	}

	public void setTenantPhone(String tenantPhone) {
		this.tenantPhone = tenantPhone;
	}

	public String getTenantUserName() {
		return tenantUserName;
	}

	public void setTenantUserName(String tenantUserName) {
		this.tenantUserName = tenantUserName;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getInsideOrgId() {
		return insideOrgId;
	}

	public void setInsideOrgId(Long insideOrgId) {
		this.insideOrgId = insideOrgId;
	}
	
}
