package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 银行账户实体
 * 
 * @author generator
 * 
 */
@RestController
@RequestMapping("bankAccount")
public class BankAccountController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    private static final String BILL_TYPE_CODE = "BT211028000000001";
    
    @Autowired
    private IBankAccountService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BankAccountVO> saveOrUpdate(@RequestBody BankAccountVO saveorUpdateVO) {
        if(saveorUpdateVO.getId() != null){
            CommonResponse<String> res = billTypeApi.checkQuote(BILL_TYPE_CODE, saveorUpdateVO.getId());
            logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()){
                throw new BusinessException("编辑失败！银行账户【" + saveorUpdateVO.getBankCode()+ "】已使用，不允许修改！");
            }
        }
        BankAccountVO vo = service.insertOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankAccountVO> queryDetail(Long id) {
    	BankAccountEntity entity = service.selectById(id);
    	BankAccountVO vo = BeanMapper.map(entity, BankAccountVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BankAccountVO> vos) {
        List<Long> ids = vos.stream().map(BankAccountVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<BankAccountEntity> list = service.queryList(queryParam);
        Map<Long, BankAccountEntity> map = list.stream().collect(Collectors.toMap(BankAccountEntity::getId, Function.identity()));
        for (BankAccountVO vo : vos){
            if(!map.containsKey(vo.getId())){
                continue;
            }
            BankAccountEntity data = map.get(vo.getId());
            CommonResponse<String> res = billTypeApi.checkQuote(BILL_TYPE_CODE, vo.getId());
            logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()){
                throw new BusinessException("删除失败！银行账户【" + data.getBankCode()+ "】已使用，不允许删除！");
            }
            if(NumberUtils.INTEGER_ONE.equals(data.getDefaultFlag())){
                throw new BusinessException("删除失败！银行账户【" + data.getBankCode()+ "】为默认账户，不允许删除！");
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BankAccountVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        if(param.getParams().containsKey("supplierId")){
            fuzzyFields.add("supplierName");
        }
        if(param.getParams().containsKey("customerId")){
            fuzzyFields.add("customerName");
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BankAccountEntity> page = service.queryPage(param,false);
        IPage<BankAccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankAccountVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        if(param.getParams().containsKey("supplierId")){
            fuzzyFields.add("supplierName");
        }
        if(param.getParams().containsKey("customerId")){
            fuzzyFields.add("customerName");
        }
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BankAccountEntity> dataList = service.queryList(param);
        List<BankAccountVO> list = BeanMapper.mapList(dataList, BankAccountVO.class);
        list.forEach(vo->{
            vo.setEnabledName(NumberUtils.INTEGER_ONE.equals(vo.getEnabled()) ? "已启用" : "已停用");
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        if(param.getParams().containsKey("supplierId")){
            ExcelExport.getInstance().export("bank-account-supplier-export.xlsx", beans, response);
        } else if(param.getParams().containsKey("customerId")){
            ExcelExport.getInstance().export("bank-account-customer-export.xlsx", beans, response);
        } else if(param.getParams().containsKey("insideOrgId")){
            ExcelExport.getInstance().export("bank-account-inside-export.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
     * @param condition
     * @Return void
     */
    @RequestMapping(value = "/refBankAccountData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BankAccountVO>> refBankAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BankAccountEntity> page = service.queryPage(param,false);
        IPage<BankAccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankAccountVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 批量启用/停用
     * @param vos
     * @return
     */
    @PostMapping("/enabled")
    public CommonResponse<String> enabled(@RequestBody List<BankAccountVO> vos) {
        return CommonResponse.success(service.enabled(vos));
    }

    /**
     * 修改默认
     * @param vo
     * @return
     */
    @PostMapping("/defaultFlag")
    public CommonResponse<String> defaultFlag(@RequestBody BankAccountVO vo) {
        return CommonResponse.success(service.defaultFlag(vo));
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "bank-account-import.xlsx", "银行账户导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<BankAccountVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }
}
