package com.ejianc.foundation.support.service;

import com.ejianc.foundation.billcode.BillCodeException;

import java.util.List;

/**
 * 单据编码生成器
 *
 * @author ejc
 * @date 2020-04-20
 */
public interface IBillCodeGenerator {
    /**
     * 生成新的单据编码
     *
     * @param code  编码规则编码
     * @param tenantId  对应租户ID
     * @return 编码
     */
    String generateBillCodeById(String code, Long tenantId) throws BillCodeException;

    /**
     * 生成新的单据编码
     *
     * @param code  编码规则编码
     * @param tenantId  对应租户ID
     * @return 编码
     */
    List<String> generateBillCodeById(String code, Long tenantId, int count) throws BillCodeException;
}
