/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.HistoricalPerformanceEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.mapper.SupplierMapper;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.IHistoricalPerformanceService;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.HistoricalPerformanceVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SupplierServiceImpl
extends BaseServiceImpl<SupplierMapper, SupplierEntity>
implements ISupplierService {
    private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private ISupplierCategoryService categoryService;
    @Autowired
    private IEnterpriseApi enterpriseApi;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${sendMessageTemplateCode}")
    private String sendMessageTemplateCode;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${insideSupplierCategoryCode:SPC-inside}")
    private String insideSupplierCategoryCode;
    @Value(value="${insideCustomerCategoryCode:CC-inside}")
    private String insideCustomerCategoryCode;
    @Autowired
    private ICustomerCategoryService customerCategoryService;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    @Autowired
    private IHistoricalPerformanceService historicalPerformanceService;

    @Override
    public List<SupplierVO> queryListByCategoryId(Long categoryId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category_id", (Object)categoryId);
        List entities = this.supplierMapper.selectList((Wrapper)wrapper);
        if (entities != null) {
            return BeanMapper.mapList((Iterable)entities, SupplierVO.class);
        }
        return null;
    }

    private List<Long> getOrgIds() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        CommonResponse nowOrg = this.orgApi.getOneById(InvocationInfoProxy.getOrgId());
        if (nowOrg.isSuccess() && nowOrg.getData() != null) {
            if (((OrgVO)nowOrg.getData()).getOrgType() == 1) {
                CommonResponse list = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
                if (list.isSuccess() && list.getData() != null && ((List)list.getData()).size() > 0) {
                    for (OrgVO vo : (List)list.getData()) {
                        orgIds.add(vo.getId());
                    }
                    return orgIds;
                }
            } else {
                CommonResponse parentlist = this.orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                if (parentlist.isSuccess() && parentlist.getData() != null && ((List)parentlist.getData()).size() > 0) {
                    CommonResponse list;
                    Long parentId = InvocationInfoProxy.getOrgId();
                    for (int i = ((List)parentlist.getData()).size() - 1; i >= 0; --i) {
                        OrgVO vo = (OrgVO)((List)parentlist.getData()).get(i);
                        if (vo.getOrgType() != 2) continue;
                        parentId = vo.getId();
                        break;
                    }
                    if ((list = this.orgApi.findChildrenByParentId(parentId)).isSuccess() && list.getData() != null && ((List)list.getData()).size() > 0) {
                        for (OrgVO vo : (List)list.getData()) {
                            orgIds.add(vo.getId());
                        }
                        return orgIds;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplierEntity entity = null;
        String operateType = null;
        this.check(supplierVo);
        if (supplierVo.getId() != null && supplierVo.getId() > 0L) {
            entity = (SupplierEntity)((Object)this.supplierMapper.selectById(supplierVo.getId()));
            entity.setCode(supplierVo.getCode());
            entity.setName(supplierVo.getName());
            entity.setCategoryId(supplierVo.getCategoryId());
            entity.setCategoryName(supplierVo.getCategoryName());
            entity.setSocialCreditCode(supplierVo.getSocialCreditCode());
            entity.setLegal(supplierVo.getLegal());
            entity.setTaxPayerType(supplierVo.getTaxPayerType());
            entity.setBusinessScope(supplierVo.getBusinessScope());
            entity.setArea(supplierVo.getArea());
            entity.setAddress(supplierVo.getAddress());
            entity.setTelephone(supplierVo.getTelephone());
            entity.setBankName(supplierVo.getBankName());
            entity.setBankAccount(supplierVo.getBankAccount());
            entity.setBankCode(supplierVo.getBankCode());
            entity.setDescription(supplierVo.getDescription());
            entity.setEnabled(supplierVo.getEnabled());
            entity.setEnterpriseNature(supplierVo.getEnterpriseNature());
            entity.setRegisterTime(supplierVo.getRegisterTime());
            entity.setTaxPayerIdentifier(supplierVo.getTaxPayerIdentifier());
            entity.setRegisteredCapital(supplierVo.getRegisteredCapital());
            entity.setLegalPhone(supplierVo.getLegalPhone());
            entity.setIssuingTime(supplierVo.getIssuingTime());
            entity.setEvaluationGrade(supplierVo.getEvaluationGrade());
            entity.setBlTime(supplierVo.getBlTime());
            entity.setSplTime(supplierVo.getSplTime());
            entity.setQcTime(supplierVo.getQcTime());
            entity.setScTime(supplierVo.getScTime());
            operateType = "edit";
        } else {
            try {
                String billCode = this.generator.generateBillCodeById(SUPPLIER_BILL_CODE, tenantId);
                supplierVo.setCode(billCode);
            }
            catch (BillCodeException e) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVo, SupplierEntity.class));
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            operateType = "add";
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getArea())) {
            String regex = "((?<provinceAndCity>[^\u5e02]+\u5e02|.*?\u81ea\u6cbb\u5dde|.*?\u533a|.*\u53bf)(?<town>[^\u533a]+\u533a|.*?\u5e02|.*?\u53bf|.*?\u8def|.*?\u8857|.*?\u9053|.*?\u9547|.*?\u65d7)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
            while (matcher.find()) {
                try {
                    entity.setRegion(matcher.group("town"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                String regex2 = "((?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a|\u4e0a\u6d77\u5e02|\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u91cd\u5e86\u5e02|\u4e0a\u6d77|\u5317\u4eac|\u5929\u6d25|\u91cd\u5e86|\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a|\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a)(?<city>.*))";
                Object provinceAndCity = "";
                try {
                    provinceAndCity = matcher.group("provinceAndCity");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Matcher matcher2 = Pattern.compile(regex2).matcher((CharSequence)provinceAndCity);
                while (matcher2.find()) {
                    try {
                        entity.setProvince(matcher.group("province"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        String city = matcher2.group("city");
                        if (StringUtils.isBlank((CharSequence)city)) {
                            entity.setCity(entity.getProvince());
                            continue;
                        }
                        entity.setCity(matcher.group("city"));
                    }
                    catch (IllegalArgumentException city) {}
                }
            }
        }
        super.saveOrUpdate((Object)entity);
        List supplierLinkerVos = supplierVo.getGridheaders();
        ArrayList<SupplierLinkerEntity> saveOrUpldates = new ArrayList<SupplierLinkerEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (SupplierLinkerVO supplierLinkerVo : supplierLinkerVos) {
            SupplierLinkerEntity supplierLinkerEntity;
            if ("add".equals(supplierLinkerVo.getRowState())) {
                supplierLinkerEntity = (SupplierLinkerEntity)((Object)BeanMapper.map((Object)supplierLinkerVo, SupplierLinkerEntity.class));
                supplierLinkerEntity.setSupplierId(entity.getId());
                saveOrUpldates.add(supplierLinkerEntity);
                continue;
            }
            if ("edit".equals(supplierLinkerVo.getRowState())) {
                supplierLinkerEntity = (SupplierLinkerEntity)((Object)BeanMapper.map((Object)supplierLinkerVo, SupplierLinkerEntity.class));
                saveOrUpldates.add(supplierLinkerEntity);
                continue;
            }
            if (!"del".equals(supplierLinkerVo.getRowState())) continue;
            deleteIds.add(supplierLinkerVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.supplierLinkerService.removeByIds(deleteIds, false);
        }
        List performanceVos = supplierVo.getPerformanceVos();
        ArrayList<HistoricalPerformanceEntity> saves = new ArrayList<HistoricalPerformanceEntity>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (HistoricalPerformanceVO vo : performanceVos) {
            HistoricalPerformanceEntity performanceEntity;
            if ("add".equals(vo.getRowState())) {
                performanceEntity = (HistoricalPerformanceEntity)((Object)BeanMapper.map((Object)vo, HistoricalPerformanceEntity.class));
                performanceEntity.setSupplierId(entity.getId());
                saves.add(performanceEntity);
                continue;
            }
            if ("edit".equals(vo.getRowState())) {
                performanceEntity = (HistoricalPerformanceEntity)((Object)BeanMapper.map((Object)vo, HistoricalPerformanceEntity.class));
                saves.add(performanceEntity);
                continue;
            }
            if (!"del".equals(vo.getRowState())) continue;
            delIds.add(vo.getId());
        }
        if (saves.size() > 0) {
            this.historicalPerformanceService.saveOrUpdateBatch(saves, saves.size(), false);
        }
        if (delIds.size() > 0) {
            this.historicalPerformanceService.removeByIds(delIds, false);
        }
        SupplierVO vo = this.queryDetail(entity.getId());
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = (SupplierCategoryEntity)((Object)this.supplierCategoryService.selectById(vo.getCategoryId()));
        parent.put("id", (Object)e.getId());
        parent.put("code", (Object)e.getCode());
        parent.put("name", (Object)e.getName());
        vo.setParent(parent);
        return CommonResponse.success((Object)vo);
    }

    private void check(SupplierVO supplierVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (supplierVo.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)supplierVo.getId());
        }
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"social_credit_code", (Object)supplierVo.getSocialCreditCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            throw new BusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\uff01\uff01\uff01");
        }
    }

    @Override
    public SupplierVO queryDetail(Long id) {
        SupplierEntity entity = (SupplierEntity)((Object)this.supplierMapper.selectById(id));
        if (entity != null) {
            List historicalPerformanceEntities;
            SupplierVO supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List supplierLinkers = this.supplierLinkerService.queryList(queryParam, false);
            if (supplierLinkers != null && supplierLinkers.size() > 0) {
                List supplierLinkerVos = BeanMapper.mapList((Iterable)supplierLinkers, SupplierLinkerVO.class);
                supplierVo.setGridheaders(supplierLinkerVos);
            }
            if ((historicalPerformanceEntities = this.historicalPerformanceService.queryList(queryParam, false)) != null && historicalPerformanceEntities.size() > 0) {
                List vos = BeanMapper.mapList((Iterable)historicalPerformanceEntities, HistoricalPerformanceVO.class);
                supplierVo.setPerformanceVos(vos);
            }
            return supplierVo;
        }
        return null;
    }

    @Override
    public void deleteSupplier(List<Long> ids) {
        for (Long id : ids) {
            this.supplierLinkerService.deleteBySupplierId(id);
            this.historicalPerformanceService.deleteBySupplierId(id);
            this.supplierMapper.deleteById(id);
        }
    }

    @Override
    public void enableSupplierOrNot(Map<String, Object> data) {
        this.supplierMapper.enableSupplierOrNot(data);
    }

    @Override
    public IPage<SupplierVO> queryPageList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                SupplierCategoryEntity categoryEntity;
                if (!StringUtils.isNotBlank((CharSequence)((Parameter)entry.getValue()).getValue().toString()) || (categoryEntity = this.categoryService.queryDetail(Long.parseLong(((Parameter)entry.getValue()).getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<SupplierEntity> supplierEntities = this.supplierMapper.queryList(condition);
        Long count = this.supplierMapper.queryCount(condition);
        ArrayList<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
        SupplierVO supplierVo = null;
        for (SupplierEntity entity : supplierEntities) {
            supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            DefdocDetailVO taxPayerTypeVo = this.defdocDetailService.queryDetail(supplierVo.getTaxPayerType());
            if (taxPayerTypeVo != null) {
                supplierVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
            }
            supplierVos.add(supplierVo);
        }
        Page resultPage = new Page();
        resultPage.setCurrent((long)queryParam.getPageIndex());
        resultPage.setRecords(supplierVos);
        resultPage.setTotal(count.longValue());
        return resultPage;
    }

    @Override
    public List<SupplierVO> queryExportList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<SupplierEntity> supplierEntities = this.supplierMapper.queryExportList(condition);
        ArrayList<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
        SupplierVO supplierVo = null;
        for (SupplierEntity entity : supplierEntities) {
            supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            DefdocDetailVO taxPayerTypeVo = this.defdocDetailService.queryDetail(supplierVo.getTaxPayerType());
            if (taxPayerTypeVo != null) {
                supplierVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
            }
            QueryParam linkerQueryParam = new QueryParam();
            linkerQueryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierVo.getId()));
            List linkerEntities = this.supplierLinkerService.queryList(linkerQueryParam, false);
            if (linkerEntities != null && linkerEntities.size() > 0) {
                SupplierLinkerEntity linkerEntity = (SupplierLinkerEntity)((Object)linkerEntities.get(0));
                supplierVo.setLinkman(linkerEntity.getLinkman());
                supplierVo.setCellphone(linkerEntity.getCellphone());
            }
            supplierVos.add(supplierVo);
        }
        return supplierVos;
    }

    @Override
    public SupplierVO queryDetailBySocialCode(String socialCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"social_credit_code", (Object)socialCode);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List entities = this.supplierMapper.selectList((Wrapper)queryWrapper);
        if (entities != null && entities.size() > 0) {
            return (SupplierVO)BeanMapper.map(entities.get(0), SupplierVO.class);
        }
        return null;
    }

    @Override
    public IPage<SupplierVO> queryRefMaterialPage(Map<String, Object> params) {
        List<SupplierEntity> supplierEntities = this.supplierMapper.queryList(params);
        Long count = this.supplierMapper.queryCount(params);
        ArrayList<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
        SupplierVO supplierVo = null;
        for (SupplierEntity entity : supplierEntities) {
            supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            DefdocDetailVO taxPayerTypeVo = this.defdocDetailService.queryDetail(supplierVo.getTaxPayerType());
            if (taxPayerTypeVo != null) {
                supplierVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
            }
            supplierVos.add(supplierVo);
        }
        Page resultPage = new Page();
        resultPage.setRecords(supplierVos);
        resultPage.setTotal(count.longValue());
        return resultPage;
    }

    @Override
    public CommonResponse<String> supplierCollaboration(SupplierVO supplierVO) {
        EnterpriseVO enterpriseVO = new EnterpriseVO();
        enterpriseVO.setName(supplierVO.getName());
        enterpriseVO.setId(Long.valueOf(IdWorker.getId()));
        enterpriseVO.setCode(String.valueOf(enterpriseVO.getId() + 1L));
        enterpriseVO.setTelephone(supplierVO.getTelephone());
        enterpriseVO.setSocialCreditCode(supplierVO.getSocialCreditCode());
        enterpriseVO.setExamineState("1");
        enterpriseVO.setAuditName(supplierVO.getLegal());
        enterpriseVO.setRegisterPhoneNum(supplierVO.getTelephone());
        CommonResponse back = this.enterpriseApi.supplierCollaboration(enterpriseVO);
        if (back.isSuccess()) {
            if (StringUtils.isNotBlank((CharSequence)this.sendMessageTemplateCode)) {
                JSONObject messageParam = new JSONObject();
                messageParam.put("phone", (Object)supplierVO.getTelephone());
                if (StringUtils.isBlank((CharSequence)this.sendMessageTemplateCode)) {
                    messageParam.put("templateCode", (Object)"SMS_195335074");
                } else {
                    messageParam.put("templateCode", (Object)this.sendMessageTemplateCode);
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("account", supplierVO.getTelephone());
                params.put("password", "a123456");
                messageParam.put("params", params);
                String messageUrl = this.baseHost + "/ejc-message-web/no_auth/sms/sendMessage";
                try {
                    String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
                    this.logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u6d88\u606f\u7ed3\u679c\uff1a[{}]", (Object)supplierVO.getTelephone(), (Object)responseStr);
                    CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
                    if (response.isSuccess()) {
                        this.logger.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                    }
                }
                catch (ConnectTimeoutException e) {
                    this.logger.info(e.toString());
                    e.printStackTrace();
                }
                catch (SocketTimeoutException e) {
                    this.logger.info(e.toString());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    this.logger.info(e.toString());
                    e.printStackTrace();
                }
            }
            this.logger.info("\u56de\u5199\u4f9b\u65b9\u79df\u6237\u4fe1\u606f\u5f00\u59cb----------->");
            EnterpriseVO enterprise = (EnterpriseVO)back.getData();
            SupplierEntity entity = (SupplierEntity)((Object)this.getById(supplierVO.getId()));
            entity.setTelephone(supplierVO.getTelephone());
            entity.setTenant(enterprise.getTenantId());
            entity.setTenantName(supplierVO.getName());
            entity.setTenantPhone(supplierVO.getTelephone());
            entity.setTenantUserName(supplierVO.getLegal());
            this.saveOrUpdate((Object)entity, false);
            this.logger.info("----------->\u56de\u5199\u4f9b\u65b9\u79df\u6237\u4fe1\u606f\u7ed3\u675f");
            return CommonResponse.success((String)"\u751f\u6210\u4f01\u4e1a\u8d26\u53f7\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)back.getMsg());
    }

    @Override
    public SupplierVO querySupplierByTenantId(Long tenant) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant", (Object)tenant);
        List entities = this.supplierMapper.selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            return (SupplierVO)BeanMapper.map(entities.get(0), SupplierVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<String> generateInsideSupplierAndCustomer(List<OrgVO> orgList) {
        if (orgList != null && orgList.size() > 0) {
            QueryWrapper querySupplierCategoryWrapper = new QueryWrapper();
            querySupplierCategoryWrapper.eq((Object)"code", (Object)this.insideSupplierCategoryCode);
            querySupplierCategoryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List supplierCategoryList = this.categoryService.list((Wrapper)querySupplierCategoryWrapper);
            SupplierCategoryEntity supplierCategory = null;
            if (supplierCategoryList != null && supplierCategoryList.size() > 0) {
                supplierCategory = (SupplierCategoryEntity)((Object)supplierCategoryList.get(0));
            } else {
                supplierCategory = new SupplierCategoryEntity();
                Long id = IdWorker.getId();
                supplierCategory.setCode(this.insideSupplierCategoryCode);
                supplierCategory.setName("\u5185\u90e8\u4f9b\u5e94\u5546");
                supplierCategory.setId(id);
                supplierCategory.setInnerCode(id.toString());
                this.categoryService.saveOrUpdate((Object)supplierCategory, false);
            }
            QueryWrapper queryCustomerCategoryWrapper = new QueryWrapper();
            queryCustomerCategoryWrapper.eq((Object)"code", (Object)this.insideCustomerCategoryCode);
            queryCustomerCategoryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List customerCategoryList = this.customerCategoryService.list((Wrapper)queryCustomerCategoryWrapper);
            CustomerCategoryEntity customerCategory = null;
            if (customerCategoryList != null && customerCategoryList.size() > 0) {
                customerCategory = (CustomerCategoryEntity)((Object)customerCategoryList.get(0));
            } else {
                customerCategory = new CustomerCategoryEntity();
                Long id = IdWorker.getId();
                customerCategory.setCode(this.insideCustomerCategoryCode);
                customerCategory.setName("\u5185\u90e8\u5ba2\u6237");
                customerCategory.setId(id);
                customerCategory.setInnerCode(id.toString());
                this.customerCategoryService.saveOrUpdate((Object)customerCategory, false);
            }
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (OrgVO orgVO : orgList) {
                orgIds.add(orgVO.getId());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"inside_org_id", orgIds);
            queryWrapper.eq((Object)"dr", (Object)0);
            List exitList = this.list((Wrapper)queryWrapper);
            String exitmsg = "";
            List<Object> addVO = new ArrayList();
            if (exitList != null && exitList.size() > 0) {
                ArrayList<Long> exitOrgIds = new ArrayList<Long>();
                for (SupplierEntity supplierEntity : exitList) {
                    exitOrgIds.add(supplierEntity.getInsideOrgId());
                    if (exitmsg.length() > 0) {
                        exitmsg = exitmsg + "," + supplierEntity.getName();
                        continue;
                    }
                    exitmsg = exitmsg + supplierEntity.getName();
                }
                if (exitList.size() == orgList.size()) {
                    return CommonResponse.success((String)("\u7ec4\u7ec7\uff1a" + exitmsg + "\u5df2\u751f\u6210\u5ba2\u5546\u6863\u6848"));
                }
                for (OrgVO orgVO : orgList) {
                    if (exitOrgIds.contains(orgVO.getId())) continue;
                    addVO.add(orgVO);
                }
            } else {
                addVO = orgList;
            }
            ArrayList<SupplierEntity> addSupplierEntity = new ArrayList<SupplierEntity>();
            ArrayList<CustomerEntity> addCustomerEntity = new ArrayList<CustomerEntity>();
            for (OrgVO orgVO : addVO) {
                SupplierEntity supplierEntity = new SupplierEntity();
                supplierEntity.setCode(orgVO.getCode());
                supplierEntity.setName(orgVO.getName());
                supplierEntity.setLegal(orgVO.getManager());
                supplierEntity.setTelephone(orgVO.getPhone());
                supplierEntity.setCategoryId(supplierCategory.getId());
                supplierEntity.setCategoryName(supplierCategory.getName());
                supplierEntity.setId(orgVO.getId());
                supplierEntity.setInsideOrgId(orgVO.getId());
                supplierEntity.setEnabled(1);
                supplierEntity.setOrgId(orgVO.getId());
                addSupplierEntity.add(supplierEntity);
                CustomerEntity customerEntity = new CustomerEntity();
                customerEntity.setCode(orgVO.getCode());
                customerEntity.setName(orgVO.getName());
                customerEntity.setLegal(orgVO.getManager());
                customerEntity.setTelephone(orgVO.getPhone());
                customerEntity.setCategoryId(customerCategory.getId());
                customerEntity.setCategoryName(customerCategory.getName());
                customerEntity.setId(orgVO.getId());
                customerEntity.setInsideOrgId(orgVO.getId());
                customerEntity.setOrgId(orgVO.getId());
                customerEntity.setOrgName(orgVO.getName());
                addCustomerEntity.add(customerEntity);
            }
            if (addSupplierEntity != null && addSupplierEntity.size() > 0) {
                this.saveOrUpdateBatch(addSupplierEntity, addSupplierEntity.size(), false);
                this.customerService.saveOrUpdateBatch(addCustomerEntity, addCustomerEntity.size(), false);
            }
            if (exitmsg.length() > 0) {
                return CommonResponse.success((String)("\u751f\u6210\u5185\u90e8\u5ba2\u5546\u6210\u529f\uff0c\u5176\u4e2d\u4ee5\u4e0b\u7ec4\u7ec7\uff1a" + exitmsg + "\u5df2\u751f\u6210\u5ba2\u5546\u6863\u6848"));
            }
        } else {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u751f\u6210\u5ba2\u5546\u7684\u7ec4\u7ec7\uff01\uff01\uff01");
        }
        return CommonResponse.success((String)"\u751f\u6210\u5185\u90e8\u5ba2\u5546\u6210\u529f\uff01");
    }
}

