/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import com.ejianc.foundation.billcode.service.IBillCodeProvider;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="generator")
public class SimpleBillCodeGeneratorImpl
implements IBillCodeGenerator {
    private final String BILL_CODE_PREFIX = "ejcbillcode:";
    @Autowired
    private IBillCodeRuleService billCodeRuleService;
    @Autowired
    private IBillCodeProvider provider;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IBillCodeEngineService billCodeEngineService;

    @Override
    public String generateBillCodeById(String code, Long tenantId) throws BillCodeException {
        BillCodeRuleVO ruleVO = this.billCodeRuleService.queryDetailByCodeAndTenantId(code, tenantId);
        this.checkIsBeyondMaxSn(ruleVO, null, 1, tenantId);
        return this.provider.getBillCode(ruleVO, null, null, null, tenantId);
    }

    @Override
    public List<String> generateBillCodeById(String code, Long tenantId, int count) throws BillCodeException {
        BillCodeRuleVO ruleVO = this.billCodeRuleService.queryDetailByCodeAndTenantId(code, tenantId);
        this.checkIsBeyondMaxSn(ruleVO, null, count, tenantId);
        String[] codes = this.provider.getBillCode(ruleVO, null, null, null, count, tenantId);
        return Arrays.asList(codes);
    }

    private void checkIsBeyondMaxSn(BillCodeRuleVO ruleVO, String customSnReferMark, int count, Long tenantId) {
        int lastSn;
        List attrs = ruleVO.getAttrs();
        StringBuffer markstr = new StringBuffer();
        int maxSn = 0;
        for (BillCodeRuleAttrVO vo : attrs) {
            maxSn = this.getMaxSn(maxSn, vo);
            markstr = this.getMarkstr(markstr, customSnReferMark, vo);
        }
        String cacheKey = this.getBillCodeSnReferCacheKey(ruleVO.getId().toString(), markstr.toString(), tenantId);
        BillCodeSNVO billcodesnVO = (BillCodeSNVO)((Object)this.cacheManager.get(cacheKey));
        if (null == billcodesnVO) {
            billcodesnVO = this.billCodeEngineService.querySNVO(ruleVO.getId().toString(), markstr.toString(), tenantId);
            this.cacheManager.set(cacheKey, (Serializable)((Object)billcodesnVO));
        }
        cacheKey = null;
        if (null != billcodesnVO && (lastSn = Integer.parseInt(billcodesnVO.getLastsn()) + count) > maxSn) {
            throw new BusinessException("\u6d41\u6c34\u53f7\u8d85\u4e86\u53ef\u7528\u6d41\u6c34\u53f7\u6700\u5927\u503c:" + maxSn + ",\u8bf7\u91cd\u65b0\u8c03\u6574\u5355\u636e\u7f16\u7801\u89c4\u5219");
        }
    }

    private String getBillCodeSnReferCacheKey(String ruleId, String billCodeSNRefer, Long tenantId) {
        return "ejcbillcode:" + ruleId + billCodeSNRefer + tenantId;
    }

    private int getMaxSn(int maxSn, BillCodeRuleAttrVO elemVO) {
        if ("0".equals(elemVO.getElemType())) {
            int snLength = elemVO.getElemLength();
            int snNum = 1;
            for (int i = 0; i < snLength - 1; ++i) {
                snNum = (int)((double)snNum + Math.pow(10.0, i + 1));
            }
            maxSn = snNum * 9;
        }
        return maxSn;
    }

    private StringBuffer getMarkstr(StringBuffer markstr, String customSnReferMark, BillCodeRuleAttrVO elemVO) {
        if ("2".equals(elemVO.getElemType())) {
            Date currentTime = new Date();
            switch (elemVO.getElemIsRefer()) {
                case "1": {
                    SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
                    markstr.append("%^sysdate^" + yearFormat.format(currentTime));
                    break;
                }
                case "2": {
                    SimpleDateFormat monthFormat = new SimpleDateFormat("yyyyMM");
                    markstr.append("%^sysdate^" + monthFormat.format(currentTime));
                    break;
                }
                case "3": {
                    SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");
                    markstr.append("%^sysdate^" + dayFormat.format(currentTime));
                    break;
                }
            }
        } else if ("5".equals(elemVO.getElemType())) {
            markstr.append("^custom^" + customSnReferMark);
        }
        return markstr;
    }
}

