/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"referTest"})
public class ReferTestController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Autowired
    private IReferService referService;
    @Autowired
    private IModuleService moduleService;

    @GetMapping(value={"loadReferModuleTree"})
    public List<ModuleEntity> loadReferModuleTree() {
        List dataList = null;
        try {
            QueryParam queryParam = new QueryParam();
            dataList = this.moduleService.queryList(queryParam, false);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u6a21\u5757\u6811\u5f02\u5e38: ", (Throwable)e);
            return null;
        }
        return dataList;
    }

    @GetMapping(value={"loadReferModuleList"})
    public CommonResponse<IPage<ModuleVO>> loadReferModuleList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize) {
        try {
            QueryParam queryParam = new QueryParam();
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            IPage pageData = this.moduleService.queryPage(queryParam, false);
            Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
            result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ModuleVO.class));
            return CommonResponse.success((Object)result);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u6a21\u5757\u6811\u5f02\u5e38: ", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"/loadReferList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReferVO>> loadReferList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String condition) {
        try {
            QueryParam queryParam = new QueryParam();
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
                Long moduleId = Long.parseLong(relyCondition.split("=")[1]);
                queryParam.getParams().put("referModule", new Parameter("eq", (Object)moduleId));
            }
            IPage pageData = this.referService.queryPage(queryParam, false);
            Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
            result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ReferVO.class));
            return CommonResponse.success((Object)result);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u6a21\u5757\u6811\u5f02\u5e38: ", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"/queryModuleListAutoSelect"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ModuleVO>> queryModuleListAutoSelect(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam String maxSize) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(Integer.parseInt(maxSize));
        queryParam.setPageIndex(1);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("moduleName", new Parameter("like", (Object)searchText));
        }
        IPage pageData = this.moduleService.queryPage(queryParam, false);
        List dataList = BeanMapper.mapList((Iterable)pageData.getRecords(), ModuleVO.class);
        return CommonResponse.success((Object)dataList);
    }
}

