/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankAccountMapper;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="bankAccountService")
public class BankAccountServiceImpl
extends BaseServiceImpl<BankAccountMapper, BankAccountEntity>
implements IBankAccountService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE_CODE = "BT211028000000001";
    @Autowired
    private IBankService bankService;
    @Autowired
    private IBankCategoryService categoryService;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public BankAccountVO insertOrUpdate(BankAccountVO saveorUpdateVO) {
        List list;
        QueryParam queryParam;
        BankAccountEntity entity = (BankAccountEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BankAccountEntity.class));
        if (StringUtils.isNotEmpty((CharSequence)entity.getBankCode())) {
            queryParam = new QueryParam();
            queryParam.getParams().put("bankCode", new Parameter("eq", (Object)entity.getBankCode()));
            if (saveorUpdateVO.getId() != null) {
                queryParam.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam)))) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u5df2\u5b58\u5728\u76f8\u540c\u8d26\u53f7\u7684\u94f6\u884c\u8d26\u6237");
            }
        }
        queryParam = new QueryParam();
        if (entity.getSupplierId() != null) {
            queryParam.getParams().put("supplierId", new Parameter("eq", (Object)entity.getSupplierId()));
        }
        if (entity.getCustomerId() != null) {
            queryParam.getParams().put("customerId", new Parameter("eq", (Object)entity.getCustomerId()));
        }
        list = super.queryList(queryParam);
        if (entity.getId() == null && CollectionUtils.isEmpty((Collection)list)) {
            entity.setDefaultFlag(1);
        }
        if (entity.getDefaultFlag() == null) {
            entity.setDefaultFlag(0);
        }
        entity.setInsideState(0);
        Long insideOrgId = entity.getInsideOrgId();
        if (insideOrgId != null) {
            SupplierEntity supplier;
            entity.setInsideState(1);
            QueryParam param = new QueryParam();
            param.getParams().put("insideOrgId", new Parameter("eq", (Object)insideOrgId));
            CustomerEntity customer = this.customerService.queryList(param).stream().findAny().orElse(null);
            if (customer != null) {
                entity.setCustomerId(customer.getId());
                entity.setCustomerName(customer.getName());
            }
            if ((supplier = (SupplierEntity)this.supplierService.queryList(param).stream().findAny().orElse(null)) != null) {
                entity.setSupplierId(supplier.getId());
                entity.setSupplierName(supplier.getName());
            }
            if (customer == null && supplier == null) {
                entity.setDefaultFlag(0);
            }
        }
        if (entity.getEnabled() == null) {
            entity.setEnabled(1);
        }
        if (entity.getEnableUserId() == null) {
            entity.setEnableUserId(InvocationInfoProxy.getUserid());
            entity.setEnableUserName(this.sessionManager.getUserContext().getUserName());
            entity.setEnableTime(new Date());
        }
        super.saveOrUpdate((Object)entity, false);
        BankAccountVO vo = (BankAccountVO)BeanMapper.map((Object)((Object)entity), BankAccountVO.class);
        return vo;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(queryParam);
        Map map = list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (Long id : ids) {
            if (!map.containsKey(id)) continue;
            BankAccountEntity data = (BankAccountEntity)((Object)map.get(id));
            CommonResponse res = this.billTypeApi.checkQuote(BILL_TYPE_CODE, id);
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237\u3010" + data.getBankCode() + "\u3011\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            if (!NumberUtils.INTEGER_ONE.equals(data.getDefaultFlag())) continue;
            QueryParam param = new QueryParam();
            if (data.getSupplierId() != null) {
                param.getParams().put("supplierId", new Parameter("in", (Object)data.getSupplierId()));
            } else if (data.getCustomerId() != null) {
                param.getParams().put("customerId", new Parameter("in", (Object)data.getCustomerId()));
            }
            if (!MapUtils.isNotEmpty((Map)param.getParams())) continue;
            param.getParams().put("id", new Parameter("ne", (Object)id));
            List dataList = super.queryList(param);
            if (!CollectionUtils.isNotEmpty((Collection)dataList)) continue;
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237\u3010" + data.getBankCode() + "\u3011\u4e3a\u9ed8\u8ba4\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        super.removeByIds(ids, true);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public String delBySuppAndCustomIds(String type, List<Long> ids) {
        if (!"supplierId".equals(type) || !"customerId".equals(type)) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u7b26\u5408\u6761\u4ef6");
        }
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u672a\u9009\u62e9\u5355\u636e");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put(type, new Parameter("in", ids));
        List list = super.queryList(queryParam);
        ArrayList delIds = new ArrayList();
        for (BankAccountEntity entity : list) {
            CommonResponse res = this.billTypeApi.checkQuote(BILL_TYPE_CODE, entity.getId());
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (res.isSuccess()) continue;
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01\u94f6\u884c\u8d26\u6237\u3010" + entity.getBankCode() + "\u3011\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, true);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BankAccountVO> voList = new ArrayList<BankAccountVO>();
            Boolean defaultFlag = false;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BankAccountVO vo2 = new BankAccountVO();
                String warnType = "";
                vo2.setId(Long.valueOf(IdWorker.getId()));
                String bankCode = (String)datas.get(0);
                vo2.setBankCode(bankCode);
                if (indexMap.containsKey(bankCode)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u8d26\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(bankCode) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(bankCode, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo2.setBankAccount(null);
                    warnType = warnType + "[\u6237\u540d\u4e3a\u7a7a]";
                } else {
                    vo2.setBankAccount((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo2.setBankName(null);
                    warnType = warnType + "[\u5f00\u6237\u94f6\u884c\u4e3a\u7a7a]";
                } else {
                    vo2.setBankName((String)datas.get(2));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    vo2.setCategoryName(null);
                    warnType = warnType + "[\u94f6\u884c\u7c7b\u522b\u4e3a\u7a7a]";
                } else {
                    vo2.setCategoryName((String)datas.get(3));
                }
                vo2.setMemo((String)datas.get(4));
                vo2.setDefaultFlagName((String)datas.get(5));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo2.setDefaultFlag(null);
                    warnType = warnType + "[\u9ed8\u8ba4\u4e3a\u7a7a]";
                } else if ("\u662f".equals(datas.get(5))) {
                    vo2.setDefaultFlag(Integer.valueOf(1));
                    if (defaultFlag.booleanValue()) {
                        vo2.setDefaultFlag(null);
                        warnType = warnType + "[\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4]";
                    }
                    defaultFlag = true;
                } else {
                    vo2.setDefaultFlag(Integer.valueOf(0));
                }
                vo2.setWarnType(warnType);
                vo2.setRowState("add");
                voList.add(vo2);
            }
            this.validate(voList);
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(voList)) {
                voList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankAccountVO> importVOS) {
        List<BankAccountEntity> list;
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        Long supplierId = null;
        Long customerId = null;
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("supplierId"))) {
            supplierId = Long.valueOf(request.getParameter("supplierId"));
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("customerId"))) {
            customerId = Long.valueOf(request.getParameter("customerId"));
            param.getParams().put("customerId", new Parameter("eq", (Object)customerId));
        }
        Long authOrgId = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("authOrgId"))) {
            authOrgId = Long.valueOf(request.getParameter("authOrgId"));
            param.getParams().put("insideOrgId", new Parameter("eq", (Object)authOrgId));
            SupplierEntity supplier = this.supplierService.queryList(param).stream().findAny().orElse(null);
            if (supplier != null) {
                supplierId = supplier.getId();
            }
        }
        List dataList = super.queryList(param);
        Boolean defaultFlag = false;
        for (BankAccountVO vo : importVOS) {
            if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag())) continue;
            defaultFlag = true;
        }
        if (!defaultFlag.booleanValue() && CollectionUtils.isEmpty((Collection)dataList)) {
            importVOS.get(0).setDefaultFlag(Integer.valueOf(1));
        }
        if (defaultFlag.booleanValue() && CollectionUtils.isNotEmpty((Collection)dataList) && CollectionUtils.isNotEmpty(list = dataList.stream().filter(x -> NumberUtils.INTEGER_ONE.equals(x.getDefaultFlag())).collect(Collectors.toList()))) {
            list.forEach(x -> x.setDefaultFlag(0));
            super.saveOrUpdateBatch(list);
        }
        String supplierName = null;
        String customerName = null;
        Long insideOrgId = null;
        Long orgId = null;
        String orgName = null;
        if (supplierId != null) {
            SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
            supplierName = supplier.getName();
            insideOrgId = supplier.getInsideOrgId();
            orgId = supplier.getOrgId();
            orgName = supplier.getOrgName();
        }
        if (customerId != null) {
            CustomerEntity customer = (CustomerEntity)((Object)this.customerService.selectById(customerId));
            customerName = customer.getName();
            insideOrgId = customer.getInsideOrgId();
            orgId = customer.getOrgId();
            orgName = customer.getOrgName();
        }
        if (insideOrgId != null) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("insideOrgId", new Parameter("eq", (Object)insideOrgId));
            if (supplierId != null) {
                CustomerEntity customer = this.customerService.queryList(queryParam).stream().findAny().orElse(null);
                customerId = customer.getId();
                customerName = customer.getName();
            } else if (customerId != null) {
                SupplierEntity supplier = this.supplierService.queryList(queryParam).stream().findAny().orElse(null);
                supplierId = supplier.getId();
                supplierName = supplier.getName();
            }
        }
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (BankAccountVO importVO : importVOS) {
            if (supplierId != null) {
                importVO.setSupplierId(supplierId);
                importVO.setSupplierName(supplierName);
            }
            if (customerId != null) {
                importVO.setCustomerId(customerId);
                importVO.setCustomerName(customerName);
            }
            if (orgId != null) {
                importVO.setOrgId(orgId);
                importVO.setOrgName(orgName);
            }
            importVO.setInsideState(Integer.valueOf(0));
            if (insideOrgId != null) {
                importVO.setInsideOrgId(insideOrgId);
                importVO.setInsideState(Integer.valueOf(1));
            }
            if (authOrgId != null && supplierId == null && customerId == null) {
                importVO.setOrgId(authOrgId);
                importVO.setOrgName(this.sessionManager.getUserContext().getOrgName());
                importVO.setInsideOrgId(authOrgId);
                importVO.setInsideState(Integer.valueOf(1));
                importVO.setDefaultFlag(Integer.valueOf(0));
            }
            importVO.setEnabled(Integer.valueOf(1));
            importVO.setEnableUserId(InvocationInfoProxy.getUserid());
            importVO.setEnableUserName(this.sessionManager.getUserContext().getUserName());
            importVO.setEnableTime(new Date());
            list2.add(BeanMapper.map((Object)importVO, BankAccountEntity.class));
        }
        if (CollectionUtils.isNotEmpty(list2)) {
            super.saveOrUpdateBatch(list2);
        }
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }

    @Override
    public String enabled(List<BankAccountVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return "\u672a\u9009\u62e9\u5355\u636e\uff01";
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List entityList = super.queryList(queryParam);
        for (BankAccountEntity entity : entityList) {
            if (!NumberUtils.INTEGER_ONE.equals(vos.get(0).getEnabled()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
                throw new BusinessException("\u3010" + entity.getBankCode() + "\u3011\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff01");
            }
            Integer enabled = vos.get(0).getEnabled();
            entity.setEnabled(enabled);
            if (enabled == 1) {
                entity.setEnableUserId(InvocationInfoProxy.getUserid());
                entity.setEnableUserName(this.sessionManager.getUserContext().getUserName());
                entity.setEnableTime(new Date());
            }
            if (enabled != 0) continue;
            entity.setUnenableUserId(InvocationInfoProxy.getUserid());
            entity.setUnenableUserName(this.sessionManager.getUserContext().getUserName());
            entity.setUnenableTime(new Date());
        }
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            super.saveOrUpdateBatch((Collection)entityList);
        }
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }

    @Override
    public String defaultFlag(BankAccountVO vo) {
        BankAccountEntity entity = (BankAccountEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u5df2\u7ecf\u4e3a\u975e\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u5df2\u7ecf\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("\u81f3\u5c11\u6709\u4e00\u4e2a\u4e3a\u9ed8\u8ba4\u94f6\u884c\u8d26\u6237\uff01");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getEnabled())) {
            throw new BusinessException("\u8be5\u94f6\u884c\u8d26\u6237\u5df2\u505c\u7528\uff01");
        }
        QueryParam param = new QueryParam();
        if (entity.getSupplierId() != null) {
            param.getParams().put("supplierId", new Parameter("eq", (Object)entity.getSupplierId()));
        }
        if (entity.getCustomerId() != null) {
            param.getParams().put("customerId", new Parameter("eq", (Object)entity.getCustomerId()));
        }
        param.getParams().put("defaultFlag", new Parameter("eq", (Object)1));
        List dataList = super.queryList(param);
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.forEach(x -> x.setDefaultFlag(0));
            super.saveOrUpdateBatch((Collection)dataList);
        }
        entity.setDefaultFlag(1);
        super.saveOrUpdate((Object)entity, false);
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }

    private void validate(List<BankAccountVO> voList) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bankCode", new Parameter("in", voList.stream().map(BankAccountVO::getBankCode).distinct().collect(Collectors.toList())));
        List dataList = super.queryList(queryParam);
        List bankCodes = dataList.stream().map(BankAccountEntity::getBankCode).distinct().collect(Collectors.toList());
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("name", new Parameter("in", voList.stream().map(BankAccountVO::getBankName).distinct().collect(Collectors.toList())));
        List bankList = this.bankService.queryList(queryParam2);
        Map bankMap = bankList.stream().collect(Collectors.toMap(x -> x.getName() + "-" + x.getBankCategoryName(), Function.identity(), (x1, x2) -> x1));
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("name", new Parameter("in", voList.stream().map(BankAccountVO::getCategoryName).distinct().collect(Collectors.toList())));
        List categoryList = this.categoryService.queryList(queryParam3);
        Map categoryMap = categoryList.stream().collect(Collectors.toMap(x -> x.getName(), Function.identity(), (x1, x2) -> x1));
        ArrayList successList = new ArrayList();
        ArrayList errorList = new ArrayList();
        if (CollectionUtils.isNotEmpty(voList)) {
            voList.forEach(vo -> {
                if (bankCodes.contains(vo.getBankCode())) {
                    vo.setWarnType(vo.getWarnType() + "[\u8d26\u53f7\u5df2\u5b58\u5728]");
                }
                if (categoryMap.containsKey(vo.getCategoryName())) {
                    vo.setCategoryId(((BankCategoryEntity)((Object)((Object)categoryMap.get(vo.getCategoryName())))).getId());
                } else {
                    vo.setWarnType(vo.getWarnType() + "[\u94f6\u884c\u7c7b\u522b\u4e0d\u5b58\u5728]");
                }
                if (bankMap.containsKey(vo.getBankName() + "-" + vo.getCategoryName())) {
                    vo.setBankId(((BankEntity)((Object)((Object)bankMap.get(vo.getBankName() + "-" + vo.getCategoryName())))).getId());
                } else {
                    vo.setWarnType(vo.getWarnType() + "[\u94f6\u884c\u6863\u6848\u4e0d\u5b58\u5728]");
                }
            });
        }
    }
}

