package com.ejianc.foundation.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.HistoricalPerformanceEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.service.IHistoricalPerformanceService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.vo.HistoricalPerformanceVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.mapper.SuplSupplierMapper;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Service
public class SuplSupplierServiceImpl extends BaseServiceImpl<SuplSupplierMapper, SupplierEntity> implements ISuplSupplierService {

    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private IHistoricalPerformanceService historicalPerformanceService;

    @Override
    public List<SupplierVO> queryListByCategoryId(Long categoryId) {
        QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("category_id", categoryId);
        List<SupplierEntity> entities = baseMapper.selectList(wrapper);
        if (entities != null) {
            return BeanMapper.mapList(entities, SupplierVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplierEntity entity = null;
        String operateType = null;
        //根据统一信用代码验重
        this.check(supplierVo);
        if (supplierVo.getId() != null && supplierVo.getId() > 0) { //修改
            entity = BeanMapper.map(supplierVo, SupplierEntity.class);
            operateType = "edit";
        } else { //新增
            throw new BusinessException("暂不允许新增");
        }

        //处理项目地区，转为省市区
        if (StringUtils.isNotBlank(entity.getArea())) {
            String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
            while (matcher.find()) {
                try {
                    entity.setRegion(matcher.group("town"));
                } catch (IllegalArgumentException e) {
                }
                String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
                String provinceAndCity = "";
                try {
                    provinceAndCity = matcher.group("provinceAndCity");
                } catch (IllegalArgumentException e) {
                }
                Matcher matcher2 = Pattern.compile(regex2).matcher(provinceAndCity);
                while (matcher2.find()) {
                    try {
                        entity.setProvince(matcher.group("province"));
                    } catch (IllegalArgumentException e) {
                    }
                    try {
                        String city = matcher2.group("city");
                        if (StringUtils.isBlank(city)) {
                            entity.setCity(entity.getProvince());
                        } else {
                            entity.setCity(matcher.group("city"));
                        }
                    } catch (IllegalArgumentException e) {
                    }

                }
            }
        }
        super.saveOrUpdate(entity);
        //子表
        List<SupplierLinkerVO> supplierLinkerVos = supplierVo.getGridheaders();
        List<SupplierLinkerEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for (SupplierLinkerVO supplierLinkerVo : supplierLinkerVos) {
            if ("add".equals(supplierLinkerVo.getRowState())) {
                SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
                supplierLinkerEntity.setSupplierId(entity.getId());
                saveOrUpldates.add(supplierLinkerEntity);
            } else if ("edit".equals(supplierLinkerVo.getRowState())) {
                SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
                saveOrUpldates.add(supplierLinkerEntity);
            } else if ("del".equals(supplierLinkerVo.getRowState())) {
                deleteIds.add(supplierLinkerVo.getId());
            }
        }
        if (saveOrUpldates.size() > 0) {
            supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            supplierLinkerService.removeByIds(deleteIds, false);
        }
        //子表
        List<HistoricalPerformanceVO> performanceVos = supplierVo.getPerformanceVos();
        List<HistoricalPerformanceEntity> saves = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        for (HistoricalPerformanceVO vo : performanceVos) {
            if ("add".equals(vo.getRowState())) {
                HistoricalPerformanceEntity performanceEntity = BeanMapper.map(vo, HistoricalPerformanceEntity.class);
                performanceEntity.setSupplierId(entity.getId());
                saves.add(performanceEntity);
            } else if ("edit".equals(vo.getRowState())) {
                HistoricalPerformanceEntity performanceEntity = BeanMapper.map(vo, HistoricalPerformanceEntity.class);
                saves.add(performanceEntity);
            } else if ("del".equals(vo.getRowState())) {
                delIds.add(vo.getId());
            }
        }
        if (saves.size() > 0) {
            historicalPerformanceService.saveOrUpdateBatch(saves, saves.size(), false);
        }
        if (delIds.size() > 0) {
            historicalPerformanceService.removeByIds(delIds, false);
        }

        SupplierVO vo = this.queryDetail(entity.getId());
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = categoryService.selectById(vo.getCategoryId());
        parent.put("id", e.getId());
        parent.put("code", e.getCode());
        parent.put("name", e.getName());
        vo.setParent(parent);
        return CommonResponse.success(vo);
    }

    @Override
    public SupplierVO queryDetail(Long id) {
        SupplierEntity entity = baseMapper.selectById(id);
        if (entity != null) {
            SupplierVO supplierVo = BeanMapper.map(entity, SupplierVO.class);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List<SupplierLinkerEntity> supplierLinkers = supplierLinkerService.queryList(queryParam, false);
            if (supplierLinkers != null && supplierLinkers.size() > 0) {
                List<SupplierLinkerVO> supplierLinkerVos = BeanMapper.mapList(supplierLinkers, SupplierLinkerVO.class);
                supplierVo.setGridheaders(supplierLinkerVos);
            }
            List<HistoricalPerformanceEntity> historicalPerformanceEntities = historicalPerformanceService.queryList(queryParam, false);
            if (historicalPerformanceEntities != null && historicalPerformanceEntities.size() > 0) {
                List<HistoricalPerformanceVO> vos = BeanMapper.mapList(historicalPerformanceEntities, HistoricalPerformanceVO.class);
                supplierVo.setPerformanceVos(vos);
            }
            return supplierVo;
        }
        return null;
    }

    @Override
    public void deleteSupplier(List<Long> ids) {
        for (Long id : ids) {
            //先删除供方联系人
            supplierLinkerService.deleteBySupplierId(id);
            historicalPerformanceService.deleteBySupplierId(id);
            baseMapper.deleteById(id);
        }
    }

    @Override
    public IPage<SupplierVO> queryPageList(QueryParam queryParam,Integer billType) {
        Map<String, Parameter> paramMap = queryParam.getParams();
        for (Map.Entry<String, Parameter> entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                if (StringUtils.isNotBlank(entry.getValue().getValue().toString())) {
                    SupplierCategoryEntity categoryEntity = categoryService.queryDetail(Long.parseLong(entry.getValue().getValue().toString()));
                    if (categoryEntity != null) {
                        LambdaQueryWrapper<SupplierCategoryEntity> lambd = new LambdaQueryWrapper<>();
                        lambd.like(SupplierCategoryEntity::getInnerCode,categoryEntity.getInnerCode());
                        List<SupplierCategoryEntity> list = categoryService.list(lambd);
                        List<Long> ids = list.stream().map(SupplierCategoryEntity::getId).collect(Collectors.toList());
                        queryParam.getParams().remove("category_id");
                        queryParam.getParams().put("category_id", new Parameter(QueryParam.IN, ids));
                    }
                }
            }
        }
        if(billType == 1){
            queryParam.getParams().put("supplierFlag", new Parameter(QueryParam.EQ, 1));
        }
        if(billType == 2){
            queryParam.getParams().put("subFlag", new Parameter(QueryParam.EQ, 1));
        }
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SupplierEntity> page = super.queryPage(queryParam, false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));
        return pageData;
    }

    // 校验同统一信用代码
    private void check(SupplierVO supplierVo) {
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        if (supplierVo.getId() != null) {
            queryWrapper.ne("id", supplierVo.getId());
        }
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("social_credit_code", supplierVo.getSocialCreditCode());
        List<SupplierEntity> list = this.list(queryWrapper);
        if (list != null && list.size() > 0) {
            throw new BusinessException("统一社会信用代码已存在！！！");
        }
    }
}
