/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.MaterialRelationEntity;
import com.ejianc.foundation.share.service.IMaterialRelationService;
import com.ejianc.foundation.share.vo.ZjwjSupplierAccountVO;
import com.ejianc.foundation.share.vo.ZjwjSupplierVO;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/zjwjsupplier/"})
public class ZjwjSupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${zjwjSupl.addr}")
    private String zjwjHost;
    @Value(value="${zjwjSupl.appId}")
    private String appId;
    @Value(value="${zjwjSupl.secret}")
    private String secret;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IMaterialRelationService materialRelationService;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"/updateIsesign"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> updateIsesign(@RequestBody ZjwjSupplierVO zjwjSupplierVO) {
        String url = this.zjwjHost + "/el/supl/supplier/updatesupplier";
        JSONObject param1 = new JSONObject();
        param1.put("pkSupplier", (Object)zjwjSupplierVO.getPkSupplier());
        param1.put("isesign", (Object)zjwjSupplierVO.getIsesign());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ZjwjSupplierVO> queryDetail(String pkSupplier) {
        String url = this.zjwjHost + "/el/supl/supplier/queryDetail";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkSupplier", pkSupplier);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + ((Object)params).toString() + "  ------------");
            String back = HttpTookit.get(url, params, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                ZjwjSupplierVO vo = (ZjwjSupplierVO)JSONObject.parseObject((String)((JSONObject)jsonBack.get((Object)"body")).toJSONString(), ZjwjSupplierVO.class);
                return CommonResponse.success((Object)vo);
            }
            this.logger.info("------------  \u8bf7\u6c42\u5931\u8d25\uff01body = " + jsonBack.toJSONString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @RequestMapping(value={"/getSupplierAccountList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ZjwjSupplierAccountVO>> getSupplierAccountList(String pkSupplier) {
        String url = this.zjwjHost + "/el/supl/account/getSupplierAccountList";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pkSupplier", pkSupplier);
        params.put("order", "desc");
        params.put("page", 1);
        params.put("rows", 100);
        params.put("sort", "ts");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + ((Object)params).toString() + "  ------------");
            String back = HttpTookit.get(url, params, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                JSONObject jsonObject = (JSONObject)jsonBack.get((Object)"body");
                JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"records");
                List voList = JSONObject.parseArray((String)jsonArray.toJSONString(), ZjwjSupplierAccountVO.class);
                return CommonResponse.success((Object)voList);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @RequestMapping(value={"/addSupplierAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> addSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
        String url = this.zjwjHost + "/el/supl/account/addSupplierAccount";
        JSONObject param1 = new JSONObject();
        param1.put("pkSupplier", (Object)zjwjSupplierAccountVO.getPkSupplier());
        param1.put("account", (Object)zjwjSupplierAccountVO.getAccount());
        param1.put("accountStatus", (Object)zjwjSupplierAccountVO.getAccountStatus());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/updateSupplierAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> updateSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
        String url = this.zjwjHost + "/el/supl/account/updateSupplierAccount";
        JSONObject param1 = new JSONObject();
        param1.put("accountStatus", (Object)zjwjSupplierAccountVO.getAccountStatus());
        param1.put("pkAccount", (Object)zjwjSupplierAccountVO.getPkAccount());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/deleteSupplierAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> deleteSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
        String url = this.zjwjHost + "/el/supl/account/deleteSupplierAccount";
        JSONObject param1 = new JSONObject();
        param1.put("pkAccount", (Object)zjwjSupplierAccountVO.getPkAccount());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/resetmd"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Object> resetmd(Integer pkAccount) {
        String url = this.zjwjHost + "/el/supl/account/resetmd";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pkAccount", pkAccount);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + ((Object)params).toString() + "  ------------");
            String back = HttpTookit.get(url, params, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                return CommonResponse.success((Object)jsonBack.get((Object)"body"));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    private CommonResponse<Object> doPostHttp(String url, String parameterStr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + parameterStr + "  ------------");
            String back = HttpTookit.postByJson(url, parameterStr, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                return CommonResponse.success((Object)jsonBack.get((Object)"body"));
            }
            this.logger.error("------------  \u8bf7\u6c42\u5931\u8d25\uff01message = " + jsonBack.getString("message") + "  ------------");
            return CommonResponse.error((String)jsonBack.getString("message"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    private CommonResponse<String> getAccessToken(Map<String, String> headers) {
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.zjwjHost + "/el/sw/auth/v1/accessToken?appId=" + this.appId + "&secret=" + this.secret;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/initEs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Object> initEs() {
        this.logger.debug("make number is 1");
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        MainDatasetCallable mainDatasetCallable = new MainDatasetCallable(this.materialRelationService, this.client);
        threadPool.submit(mainDatasetCallable);
        return CommonResponse.success((String)"\u6210\u529f");
    }

    class MainDatasetCallable
    implements Callable<CommonResponse<String>> {
        private IMaterialRelationService relationService;
        private RestHighLevelClient restHighLevelClient;

        public MainDatasetCallable(IMaterialRelationService relationService, RestHighLevelClient restHighLevelClient) {
            this.relationService = relationService;
            this.restHighLevelClient = restHighLevelClient;
        }

        @Override
        public CommonResponse<String> call() throws Exception {
            boolean flag = true;
            int pageNumber = 1;
            while (flag) {
                BulkRequest bulkRequest = new BulkRequest();
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"def10", (Object)"Y");
                wrapper.last("limit " + (pageNumber - 1) * 5000 + ", 5000");
                List relationEntityList = this.relationService.list((Wrapper)wrapper);
                if (CollectionUtils.isNotEmpty((Collection)relationEntityList)) {
                    for (MaterialRelationEntity entity : relationEntityList) {
                        HashMap<String, Object> dataMap = new HashMap<String, Object>();
                        dataMap.put("materialId", entity.getMaterialId() + "");
                        dataMap.put("categoryId", entity.getCategoryId() + "");
                        dataMap.put("innerCode", entity.getInnerCode());
                        dataMap.put("code", entity.getCode());
                        dataMap.put("categoryName", entity.getCategoryName());
                        dataMap.put("name", entity.getName());
                        dataMap.put("spec", entity.getSpec());
                        dataMap.put("model", entity.getModel());
                        dataMap.put("unitName", entity.getUnitName());
                        dataMap.put("itemType", entity.getType());
                        dataMap.put("sourceOrgId", entity.getSourceOrgId());
                        IndexRequest indexRequest = new IndexRequest("ejc_wj_org_material_relation_es");
                        indexRequest.id(entity.getId() + "");
                        indexRequest.source(dataMap, XContentType.JSON);
                        bulkRequest.add(indexRequest);
                    }
                    try {
                        this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                    }
                    catch (IOException e) {
                        ZjwjSupplierController.this.logger.error(e.getMessage());
                    }
                } else {
                    flag = false;
                    ZjwjSupplierController.this.logger.info("no data pageNumber is  ------->" + pageNumber);
                }
                if (relationEntityList.size() < 100) {
                    flag = false;
                    ZjwjSupplierController.this.logger.info("normal pageNumber is  ------->" + pageNumber);
                }
                ++pageNumber;
            }
            return CommonResponse.success((String)"\u6210\u529f");
        }
    }
}

